/*
 * Decompiled with CFR 0.152.
 */
package io.milton.httpclient;

import io.milton.httpclient.ProgressListener;
import io.milton.httpclient.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class NotifyingFileOutputStream
extends FileOutputStream {
    private final ProgressListener listener;
    private final String fileName;
    private final Long length;
    long pos;
    long timeLastNotify = System.currentTimeMillis();
    long bytesSinceLastNotify;

    public NotifyingFileOutputStream(File f, ProgressListener listener, Long length) throws FileNotFoundException {
        super(f);
        this.length = length;
        this.listener = listener;
        this.fileName = f.getAbsolutePath();
    }

    public NotifyingFileOutputStream(File f, boolean append, ProgressListener listener, Long length) throws FileNotFoundException {
        super(f, append);
        this.length = length;
        this.listener = listener;
        this.fileName = f.getAbsolutePath();
    }

    @Override
    public void write(int b) throws IOException {
        this.increment(1);
        super.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.increment(b.length);
        super.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.increment(len);
        super.write(b, off, len);
    }

    private void increment(int len) throws IOException {
        this.pos += (long)len;
        if (this.listener != null) {
            this.notifyListener(len);
        }
    }

    void notifyListener(int numBytes) throws IOException {
        this.listener.onRead(numBytes);
        if (this.listener.isCancelled()) {
            throw new Utils.CancelledException();
        }
        this.bytesSinceLastNotify += (long)numBytes;
        if (this.bytesSinceLastNotify < 1000L) {
            return;
        }
        int timeDiff = (int)(System.currentTimeMillis() - this.timeLastNotify);
        if (timeDiff > 10) {
            this.timeLastNotify = System.currentTimeMillis();
            this.listener.onProgress(numBytes, this.length, this.fileName);
            this.bytesSinceLastNotify = 0L;
        }
    }
}

