/*
 * Decompiled with CFR 0.152.
 */
package io.milton.httpclient;

import io.milton.common.LogUtils;
import io.milton.common.Path;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.httpclient.File;
import io.milton.httpclient.FolderListener;
import io.milton.httpclient.GenericHttpException;
import io.milton.httpclient.HttpException;
import io.milton.httpclient.HttpResult;
import io.milton.httpclient.IfMatchCheck;
import io.milton.httpclient.MethodNotAllowedException;
import io.milton.httpclient.ProgressListener;
import io.milton.httpclient.PropFindResponse;
import io.milton.httpclient.Resource;
import io.milton.httpclient.Utils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Folder
extends Resource {
    private static final Logger log = LoggerFactory.getLogger(Folder.class);
    final List<FolderListener> folderListeners = new ArrayList<FolderListener>();
    protected final Map<Folder, List<Resource>> cache;

    Folder(Map<Folder, List<Resource>> cache) {
        this.cache = cache;
        if (this.cache == null) {
            throw new IllegalArgumentException("cache cannot be null");
        }
    }

    public Folder(Folder parent, PropFindResponse resp, Map<Folder, List<Resource>> cache) {
        super(parent, resp);
        this.cache = cache;
        if (this.cache == null) {
            throw new IllegalArgumentException("cache cannot be null");
        }
    }

    public Folder(Folder parent, String name, Map<Folder, List<Resource>> cache) {
        super(parent, name);
        this.cache = cache;
        if (this.cache == null) {
            throw new IllegalArgumentException("cache cannot be null");
        }
    }

    public void addListener(FolderListener l) throws IOException, HttpException, NotAuthorizedException, BadRequestException {
        for (Resource resource : this.children()) {
            l.onChildAdded(resource.parent, resource);
        }
        this.folderListeners.add(l);
    }

    public String post(String relativePath, Map<String, String> params) throws HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        return this.host().doPost(this.encodedUrl() + relativePath, params);
    }

    @Override
    public java.io.File downloadTo(java.io.File destFolder, ProgressListener listener) throws FileNotFoundException, IOException, HttpException, NotAuthorizedException, BadRequestException {
        java.io.File thisDir = new java.io.File(destFolder, this.name);
        thisDir.mkdir();
        for (Resource resource : this.children()) {
            resource.downloadTo(thisDir, listener);
        }
        return thisDir;
    }

    public void flush() throws IOException {
        this.cache.remove(this);
    }

    public boolean hasChildren() throws IOException, HttpException, NotAuthorizedException, BadRequestException {
        return !this.children().isEmpty();
    }

    public int numChildren() throws IOException, HttpException, NotAuthorizedException, BadRequestException {
        return this.children().size();
    }

    public List<? extends Resource> children() throws IOException, HttpException, NotAuthorizedException, BadRequestException {
        List<Resource> children = this.cache.get(this);
        if (children == null) {
            List<PropFindResponse> responses;
            children = new ArrayList<Resource>();
            String thisHref = this.href();
            if (log.isTraceEnabled()) {
                log.trace("load children for: " + thisHref);
            }
            if ((responses = this.host()._doPropFind(this.encodedUrl(), 1, null)) != null) {
                for (PropFindResponse resp : responses) {
                    try {
                        Resource r = Resource.fromResponse(this, resp, this.cache);
                        if (!r.href().equals(thisHref)) {
                            children.add(r);
                        }
                        this.notifyOnChildAdded(r);
                    }
                    catch (Exception e) {
                        log.error("couldnt process record", (Throwable)e);
                    }
                }
            } else {
                log.trace("null responses");
            }
            this.cache.put(this, children);
        }
        return children;
    }

    public Resource getChild(int num) throws IOException, HttpException, NotAuthorizedException, BadRequestException {
        int x = 0;
        for (Resource resource : this.children()) {
            if (x++ != num) continue;
            return resource;
        }
        return null;
    }

    public void removeListener(FolderListener folderListener) {
        this.folderListeners.remove(folderListener);
    }

    @Override
    public String toString() {
        return this.href() + " (is a folder)";
    }

    public void upload(java.io.File f) throws IOException, HttpException, NotAuthorizedException, ConflictException, BadRequestException, FileNotFoundException, NotFoundException {
        this.upload(f, null);
    }

    public void upload(java.io.File f, ProgressListener listener) throws IOException, HttpException, NotAuthorizedException, ConflictException, BadRequestException, FileNotFoundException, NotFoundException {
        if (f.isDirectory()) {
            this.uploadFolder(f, listener);
        } else {
            this.uploadFile(f, listener);
        }
    }

    public File uploadFile(java.io.File f) throws FileNotFoundException, IOException, HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        return this.uploadFile(f, null);
    }

    public File uploadFile(java.io.File f, ProgressListener listener) throws FileNotFoundException, IOException, HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        return this.uploadFile(f.getName(), f, listener);
    }

    public File uploadFile(String newName, java.io.File f, ProgressListener listener) throws FileNotFoundException, IOException, HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        Path newPath = this.path().child(newName);
        this.children();
        HttpResult result = this.host().doPut(newPath, f, null, listener);
        int resultCode = result.getStatusCode();
        LogUtils.trace((Logger)log, (Object[])new Object[]{"uploadFile", newPath, " result", resultCode});
        Utils.processResultCode(resultCode, newPath.toString());
        String newEtag = result.getHeaders().get(Response.Header.ETAG.code);
        File child = new File(this, newName, null, f.length(), newEtag);
        this.flush();
        this.notifyOnChildAdded(child);
        return child;
    }

    protected void uploadFolder(java.io.File folder, ProgressListener listener) throws IOException, HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        if (folder.getName().startsWith(".")) {
            return;
        }
        Folder newFolder = this.createFolder(folder.getName());
        for (java.io.File f : folder.listFiles()) {
            newFolder.upload(f, listener);
        }
    }

    public File upload(String name, InputStream content, Integer contentLength, ProgressListener listener) throws IOException, HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        Long length = null;
        if (contentLength != null) {
            long l = contentLength.intValue();
            length = l;
        }
        return this.upload(name, content, length, listener);
    }

    public File upload(String name, InputStream content, Long contentLength, ProgressListener listener) throws IOException, HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        String contentType = URLConnection.guessContentTypeFromName(name);
        return this.upload(name, content, contentLength, contentType, null, listener);
    }

    public File upload(String name, InputStream content, Long contentLength, String contentType, IfMatchCheck matchCheck, ProgressListener listener) throws IOException, HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        this.children();
        String newUri = this.encodedUrl() + io.milton.common.Utils.percentEncode((String)name);
        log.trace("upload: " + newUri);
        HttpResult result = this.host().doPut(newUri, content, contentLength, contentType, matchCheck, listener);
        int resultCode = result.getStatusCode();
        Utils.processResultCode(resultCode, newUri);
        String newEtag = result.getHeaders().get(Response.Header.ETAG.code);
        File child = new File(this, name, contentType, contentLength, newEtag);
        Resource oldChild = this.child(child.name);
        this.flush();
        this.notifyOnChildAdded(child);
        return child;
    }

    public Folder createFolder(String name) throws IOException, HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        this.children();
        String newUri = this.encodedUrl() + io.milton.common.Utils.percentEncode((String)name);
        try {
            try {
                this.host().doMkCol(newUri);
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
            this.flush();
            Folder child = (Folder)this.child(name);
            this.notifyOnChildAdded(child);
            return child;
        }
        catch (ConflictException e) {
            return this.handlerCreateFolderException(newUri, name);
        }
        catch (MethodNotAllowedException e) {
            return this.handlerCreateFolderException(newUri, name);
        }
    }

    private Folder handlerCreateFolderException(String newUri, String name) throws IOException, HttpException, NotAuthorizedException, BadRequestException {
        this.flush();
        Resource child = this.child(name);
        if (child instanceof Folder) {
            Folder fChild = (Folder)child;
            return fChild;
        }
        if (child == null) {
            log.error("Couldnt create remote collection");
        } else {
            log.error("Remote resource exists and is not a collection");
        }
        throw new GenericHttpException(405, newUri);
    }

    public Resource child(String childName) throws IOException, HttpException, NotAuthorizedException, BadRequestException {
        for (Resource resource : this.children()) {
            if (!resource.name.equals(childName)) continue;
            return resource;
        }
        return null;
    }

    void notifyOnChildAdded(Resource child) {
        ArrayList<FolderListener> l2 = new ArrayList<FolderListener>(this.folderListeners);
        for (FolderListener l : l2) {
            l.onChildAdded(this, child);
        }
        this.cache.remove(this);
    }

    void notifyOnChildRemoved(Resource child) {
        ArrayList<FolderListener> l2 = new ArrayList<FolderListener>(this.folderListeners);
        for (FolderListener l : l2) {
            l.onChildRemoved(this, child);
        }
        this.cache.remove(this);
    }

    @Override
    public String href() {
        return super.href() + "/";
    }

    @Override
    public String encodedUrl() {
        return this.parent.encodedUrl() + this.encodedName() + "/";
    }
}

