/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus.rsocket.autoconfigure;

import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.micrometer.prometheus.rsocket.PrometheusRSocketClient;
import io.micrometer.prometheus.rsocket.autoconfigure.PrometheusRSocketProperties;
import io.rsocket.transport.ClientTransport;
import org.springframework.boot.actuate.autoconfigure.metrics.export.prometheus.PrometheusMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={PrometheusMetricsExportAutoConfiguration.class})
@ConditionalOnBean(value={PrometheusMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.prometheus.rsocket", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={PrometheusRSocketProperties.class})
public class PrometheusRSocketAutoConfiguration {
    @ConditionalOnMissingBean
    @Bean(destroyMethod="pushAndClose")
    PrometheusRSocketClient prometheusRSocketClient(PrometheusMeterRegistry meterRegistry, PrometheusRSocketProperties properties) {
        return PrometheusRSocketClient.build((PrometheusMeterRegistry)meterRegistry, (ClientTransport)properties.createClientTransport()).customizeAndRetry(c -> c.retryBackoff(properties.getMaxRetries(), properties.getFirstBackoff(), properties.getMaxBackoff())).connect();
    }
}

