/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus.rsocket;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.micrometer.prometheus.rsocket.PrometheusController;
import io.rsocket.RSocket;
import io.rsocket.RSocketFactory;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.micrometer.MicrometerRSocketInterceptor;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.server.TcpServerTransport;
import io.rsocket.transport.netty.server.WebsocketServerTransport;
import java.nio.channels.ClosedChannelException;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.pcollections.HashPMap;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
class PrometheusController {
    private final PrometheusMeterRegistry meterRegistry;
    private final Timer scrapeTimerSuccess;
    private final Timer scrapeTimerClosed;
    private final Counter scrapeSocketsClosed;
    private final Timer scrapeTimerError;
    private final DistributionSummary scrapePayload;
    private final MicrometerRSocketInterceptor metricsInterceptor;
    private AtomicReference<PMap<RSocket, ConnectionState>> scrapableApps = new AtomicReference<HashPMap>(HashTreePMap.empty());

    PrometheusController(PrometheusMeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        this.metricsInterceptor = new MicrometerRSocketInterceptor((MeterRegistry)meterRegistry, new Tag[0]);
        meterRegistry.gauge("prometheus.proxy.scrape.active.connections", (Object)this.scrapableApps, apps -> ((PMap)apps.get()).size());
        this.scrapeTimerSuccess = Timer.builder((String)"prometheus.proxy.scrape").tag("outcome", "success").publishPercentileHistogram().register((MeterRegistry)meterRegistry);
        this.scrapeTimerClosed = meterRegistry.timer("prometheus.proxy.scrape", new String[]{"outcome", "closed"});
        this.scrapeTimerError = meterRegistry.timer("prometheus.proxy.scrape", new String[]{"outcome", "error"});
        this.scrapePayload = DistributionSummary.builder((String)"prometheus.proxy.scrape.payload").publishPercentileHistogram().baseUnit("bytes").register((MeterRegistry)meterRegistry);
        this.scrapeSocketsClosed = meterRegistry.counter("prometheus.proxy.scrape.sockets.closed", new String[0]);
    }

    @PostConstruct
    public void connect() throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        RSocketFactory.receive().frameDecoder(PayloadDecoder.ZERO_COPY).acceptor((setup, sendingSocket) -> this.acceptRSocket(generator, sendingSocket)).transport((ServerTransport)TcpServerTransport.create((int)7001)).start().subscribe();
        RSocketFactory.receive().frameDecoder(PayloadDecoder.ZERO_COPY).acceptor((setup, sendingSocket) -> this.acceptRSocket(generator, sendingSocket)).transport((ServerTransport)WebsocketServerTransport.create((int)8081)).start().subscribe();
    }

    private Mono<RSocket> acceptRSocket(KeyPairGenerator generator, RSocket sendingSocket) {
        ConnectionState connectionState = new ConnectionState(this, generator.generateKeyPair());
        this.scrapableApps.getAndUpdate(apps -> apps.plus((Object)this.metricsInterceptor.apply(sendingSocket), (Object)connectionState));
        sendingSocket.fireAndForget(connectionState.createKeyPayload()).subscribe();
        return Mono.just((Object)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GetMapping(value={"/metrics/proxy"}, produces={"text/plain"})
    public Mono<String> proxyMetrics() {
        return Mono.just((Object)this.meterRegistry.scrape());
    }

    @GetMapping(value={"/metrics/connected"}, produces={"text/plain"})
    public Mono<String> prometheus() {
        return Flux.fromIterable((Iterable)((PMap)this.scrapableApps.get()).entrySet()).flatMap(socketAndState -> {
            ConnectionState connectionState = (ConnectionState)socketAndState.getValue();
            RSocket rsocket = (RSocket)socketAndState.getKey();
            Timer.Sample sample = Timer.start();
            return rsocket.requestResponse(connectionState.createKeyPayload()).map(payload -> connectionState.receiveScrapePayload(payload, sample)).onErrorResume(throwable -> {
                if (throwable instanceof ClosedChannelException) {
                    this.scrapeSocketsClosed.increment();
                    this.scrapableApps.getAndUpdate(apps -> apps.minus((Object)rsocket));
                    sample.stop(this.scrapeTimerClosed);
                    return connectionState.getDyingPush();
                }
                sample.stop(this.scrapeTimerError);
                return Mono.empty();
            });
        }).collect(Collectors.joining("\n"));
    }

    static /* synthetic */ DistributionSummary access$000(PrometheusController x0) {
        return x0.scrapePayload;
    }

    static /* synthetic */ Timer access$100(PrometheusController x0) {
        return x0.scrapeTimerSuccess;
    }
}

