/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus.rsocket;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.micrometer.prometheus.rsocket.PrometheusController;
import io.micrometer.prometheus.rsocket.PrometheusControllerProperties;
import io.rsocket.RSocket;
import io.rsocket.RSocketFactory;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.micrometer.MicrometerRSocket;
import io.rsocket.micrometer.MicrometerRSocketInterceptor;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.server.TcpServerTransport;
import io.rsocket.transport.netty.server.WebsocketServerTransport;
import java.nio.channels.ClosedChannelException;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
class PrometheusController {
    private final PrometheusMeterRegistry meterRegistry;
    private final Timer scrapeTimerSuccess;
    private final Timer scrapeTimerClosed;
    private final Counter scrapeSocketsClosed;
    private final DistributionSummary scrapePayload;
    private final MicrometerRSocketInterceptor metricsInterceptor;
    private PrometheusControllerProperties properties;
    private Map<RSocket, ConnectionState> scrapableApps = new ConcurrentHashMap();

    PrometheusController(PrometheusMeterRegistry meterRegistry, PrometheusControllerProperties properties) {
        this.meterRegistry = meterRegistry;
        this.metricsInterceptor = new MicrometerRSocketInterceptor((MeterRegistry)meterRegistry, new Tag[0]);
        this.properties = properties;
        meterRegistry.gaugeMapSize("prometheus.proxy.scrape.active.connections", (Iterable)Tags.empty(), this.scrapableApps);
        this.scrapeTimerSuccess = Timer.builder((String)"prometheus.proxy.scrape").tag("outcome", "success").publishPercentileHistogram().register((MeterRegistry)meterRegistry);
        this.scrapeTimerClosed = meterRegistry.timer("prometheus.proxy.scrape", new String[]{"outcome", "closed"});
        this.scrapePayload = DistributionSummary.builder((String)"prometheus.proxy.scrape.payload").publishPercentileHistogram().baseUnit("bytes").register((MeterRegistry)meterRegistry);
        this.scrapeSocketsClosed = meterRegistry.counter("prometheus.proxy.scrape.sockets.closed", new String[0]);
    }

    @PostConstruct
    public void connect() throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        RSocketFactory.receive().frameDecoder(PayloadDecoder.ZERO_COPY).acceptor((setup, sendingSocket) -> this.acceptRSocket(generator, sendingSocket)).transport((ServerTransport)TcpServerTransport.create((int)this.properties.getTcpPort())).start().subscribe();
        RSocketFactory.receive().frameDecoder(PayloadDecoder.ZERO_COPY).acceptor((setup, sendingSocket) -> this.acceptRSocket(generator, sendingSocket)).transport((ServerTransport)WebsocketServerTransport.create((int)this.properties.getWebsocketPort())).start().subscribe();
    }

    private Mono<RSocket> acceptRSocket(KeyPairGenerator generator, RSocket sendingSocket) {
        MicrometerRSocket metricsInterceptedSendingSocket = this.metricsInterceptor.apply(sendingSocket);
        ConnectionState connectionState = new ConnectionState(this, generator.generateKeyPair());
        this.scrapableApps.put(metricsInterceptedSendingSocket, connectionState);
        metricsInterceptedSendingSocket.fireAndForget(connectionState.createKeyPayload()).subscribe();
        1 dyingPushReceiver = new /* Unavailable Anonymous Inner Class!! */;
        return Mono.just((Object)dyingPushReceiver);
    }

    @GetMapping(value={"/metrics/proxy"}, produces={"text/plain"})
    public Mono<String> proxyMetrics() {
        return Mono.just((Object)this.meterRegistry.scrape());
    }

    @GetMapping(value={"/metrics/connected"}, produces={"text/plain"})
    public Mono<String> prometheus() {
        return Flux.fromIterable(this.scrapableApps.entrySet()).flatMap(socketAndState -> {
            ConnectionState connectionState = (ConnectionState)socketAndState.getValue();
            RSocket rsocket = (RSocket)socketAndState.getKey();
            Timer.Sample sample = Timer.start();
            return rsocket.requestResponse(connectionState.createKeyPayload()).map(payload -> connectionState.receiveScrapePayload(payload, sample)).onErrorResume(throwable -> {
                this.scrapeSocketsClosed.increment();
                if (this.scrapableApps.remove(rsocket) == null) {
                    this.meterRegistry.counter("prometheus.proxy.unrecognized.rsocket", new String[0]).increment();
                }
                if (throwable instanceof ClosedChannelException) {
                    sample.stop(this.scrapeTimerClosed);
                    return connectionState.getDyingPush();
                }
                sample.stop(this.meterRegistry.timer("prometheus.proxy.scrape", new String[]{"outcome", "error", "exception", throwable.getClass().getName()}));
                return Mono.empty();
            });
        }).collect(Collectors.joining("\n"));
    }

    static /* synthetic */ DistributionSummary access$000(PrometheusController x0) {
        return x0.scrapePayload;
    }

    static /* synthetic */ Timer access$100(PrometheusController x0) {
        return x0.scrapeTimerSuccess;
    }
}

