/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus.rsocket;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.rsocket.AbstractRSocket;
import io.rsocket.Closeable;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.RSocketFactory;
import io.rsocket.transport.ClientTransport;
import io.rsocket.util.DefaultPayload;
import java.nio.ByteBuffer;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.xerial.snappy.Snappy;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PrometheusRSocketClient {
    private final PrometheusMeterRegistry registry;
    private final Disposable connection;
    private AtomicReference<PublicKey> latestKey = new AtomicReference();
    private final AbstractRSocket rsocket = new AbstractRSocket(){

        public Mono<Payload> requestResponse(Payload payload) {
            PublicKey key = PrometheusRSocketClient.this.decodePublicKey(payload.getData());
            PrometheusRSocketClient.this.latestKey.set(key);
            return Mono.just((Object)PrometheusRSocketClient.this.scrapePayload(key));
        }

        public Mono<Void> fireAndForget(Payload payload) {
            PrometheusRSocketClient.this.latestKey.set(PrometheusRSocketClient.this.decodePublicKey(payload.getData()));
            return Mono.empty();
        }
    };
    private boolean pushOnDisconnect = false;
    private RSocket sendingSocket;

    public PrometheusRSocketClient(PrometheusMeterRegistry registry, ClientTransport transport, UnaryOperator<Flux<Void>> customizeAndRetry) {
        this.registry = registry;
        Counter attempts = Counter.builder((String)"prometheus.connection.attempts").description("Attempts at making an outbound RSocket connection to the Prometheus proxy").baseUnit("attempts").register((MeterRegistry)registry);
        attempts.increment();
        this.connection = ((Flux)customizeAndRetry.apply(RSocketFactory.connect().acceptor(r -> {
            this.sendingSocket = r;
            return this.rsocket;
        }).transport(transport).start().doOnCancel(() -> {
            PublicKey key;
            if (this.pushOnDisconnect && (key = this.latestKey.get()) != null) {
                this.sendingSocket.fireAndForget(this.scrapePayload(key)).block(Duration.ofSeconds(10L));
            }
        }).flatMap(Closeable::onClose).repeat(() -> {
            attempts.increment();
            return true;
        }))).subscribe();
    }

    public void close() {
        this.connection.dispose();
    }

    public void pushAndClose() {
        this.pushOnDisconnect = true;
        this.close();
    }

    private Payload scrapePayload(PublicKey publicKey) {
        try {
            KeyGenerator generator = KeyGenerator.getInstance("AES");
            generator.init(128);
            SecretKey secKey = generator.generateKey();
            Cipher aesCipher = Cipher.getInstance("AES");
            aesCipher.init(1, secKey);
            byte[] encryptedMetrics = aesCipher.doFinal(Snappy.compress((String)this.registry.scrape()));
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-256AndMGF1Padding");
            cipher.init(1, publicKey);
            byte[] encryptedPublicKey = cipher.doFinal(secKey.getEncoded());
            return DefaultPayload.create((byte[])encryptedMetrics, (byte[])encryptedPublicKey);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    private PublicKey decodePublicKey(ByteBuffer encodedKeyBuffer) {
        byte[] encodedKey = new byte[encodedKeyBuffer.capacity()];
        encodedKeyBuffer.get(encodedKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException(e);
        }
    }
}

