/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing;

import io.micrometer.tracing.Link;
import io.micrometer.tracing.SpanCustomizer;
import io.micrometer.tracing.TraceContext;
import java.util.concurrent.TimeUnit;

public interface Span
extends SpanCustomizer {
    public static final Span NOOP = new Span(){

        @Override
        public boolean isNoop() {
            return true;
        }

        @Override
        public TraceContext context() {
            return TraceContext.NOOP;
        }

        @Override
        public Span start() {
            return this;
        }

        @Override
        public Span name(String name) {
            return this;
        }

        @Override
        public Span event(String value) {
            return this;
        }

        @Override
        public Span event(String value, long time, TimeUnit timeUnit) {
            return this;
        }

        @Override
        public Span tag(String key, String value) {
            return this;
        }

        @Override
        public Span error(Throwable throwable) {
            return this;
        }

        @Override
        public void end() {
        }

        @Override
        public void end(long time, TimeUnit timeUnit) {
        }

        @Override
        public void abandon() {
        }

        @Override
        public Span remoteServiceName(String remoteServiceName) {
            return this;
        }

        @Override
        public Span remoteIpAndPort(String ip, int port) {
            return this;
        }
    };

    public boolean isNoop();

    public TraceContext context();

    public Span start();

    @Override
    public Span name(String var1);

    @Override
    public Span event(String var1);

    public Span event(String var1, long var2, TimeUnit var4);

    @Override
    public Span tag(String var1, String var2);

    @Override
    default public Span tag(String key, long value) {
        return this.tag(key, String.valueOf(value));
    }

    @Override
    default public Span tag(String key, double value) {
        return this.tag(key, String.valueOf(value));
    }

    @Override
    default public Span tag(String key, boolean value) {
        return this.tag(key, String.valueOf(value));
    }

    public Span error(Throwable var1);

    public void end();

    public void end(long var1, TimeUnit var3);

    public void abandon();

    public Span remoteServiceName(String var1);

    public Span remoteIpAndPort(String var1, int var2);

    public static interface Builder {
        public static final Builder NOOP = new Builder(){

            @Override
            public Builder setParent(TraceContext context) {
                return this;
            }

            @Override
            public Builder setNoParent() {
                return this;
            }

            @Override
            public Builder name(String name) {
                return this;
            }

            @Override
            public Builder event(String value) {
                return this;
            }

            @Override
            public Builder tag(String key, String value) {
                return this;
            }

            @Override
            public Builder error(Throwable throwable) {
                return this;
            }

            @Override
            public Builder kind(Kind spanKind) {
                return this;
            }

            @Override
            public Builder remoteServiceName(String remoteServiceName) {
                return this;
            }

            @Override
            public Builder remoteIpAndPort(String ip, int port) {
                return this;
            }

            @Override
            public Builder startTimestamp(long startTimestamp, TimeUnit unit) {
                return this;
            }

            @Override
            public Span start() {
                return Span.NOOP;
            }
        };

        public Builder setParent(TraceContext var1);

        public Builder setNoParent();

        public Builder name(String var1);

        public Builder event(String var1);

        public Builder tag(String var1, String var2);

        default public Builder tag(String key, long value) {
            return this.tag(key, String.valueOf(value));
        }

        default public Builder tag(String key, double value) {
            return this.tag(key, String.valueOf(value));
        }

        default public Builder tag(String key, boolean value) {
            return this.tag(key, String.valueOf(value));
        }

        public Builder error(Throwable var1);

        public Builder kind(Kind var1);

        public Builder remoteServiceName(String var1);

        public Builder remoteIpAndPort(String var1, int var2);

        public Builder startTimestamp(long var1, TimeUnit var3);

        default public Builder addLink(Link link) {
            return this;
        }

        public Span start();
    }

    public static enum Kind {
        SERVER,
        CLIENT,
        PRODUCER,
        CONSUMER;

    }
}

