/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.test.simple;

import io.micrometer.tracing.Span;
import io.micrometer.tracing.SpanAndScope;
import io.micrometer.tracing.Tracer;

public class SimpleSpanInScope
implements Tracer.SpanInScope {
    private volatile boolean closed;
    private final ThreadLocal<SpanAndScope> scopedSpans;
    private final Span span;
    private final SpanAndScope spanAndScope;
    private final SpanAndScope previousSpanAndScope;

    public SimpleSpanInScope(Span span, ThreadLocal<SpanAndScope> scopedSpans) {
        this.span = span;
        this.scopedSpans = scopedSpans;
        this.spanAndScope = new SpanAndScope(span, (Tracer.SpanInScope)this);
        this.previousSpanAndScope = scopedSpans.get();
        if (span != null) {
            this.scopedSpans.set(this.spanAndScope);
        } else {
            this.scopedSpans.remove();
        }
    }

    public void close() {
        this.closed = true;
        SpanAndScope current = this.scopedSpans.get();
        if (current != null && current != this.spanAndScope) {
            throw new IllegalStateException("Trying to close scope for span [" + this.span + "] but current span in scope is [" + current.getSpan() + "]");
        }
        this.scopedSpans.set(this.previousSpanAndScope);
    }

    public boolean isClosed() {
        return this.closed;
    }
}

