/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.common.util.StringUtils;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.tracing.otel.bridge.EventListener;
import io.micrometer.tracing.otel.bridge.EventPublishingContextWrapper;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.Span;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.MDC;

public class Slf4JBaggageEventListener
implements EventListener {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(Slf4JBaggageEventListener.class);
    private final List<String> lowerCaseCorrelationFields;
    private final List<String> correlationFields;

    public Slf4JBaggageEventListener(List<String> correlationFields) {
        this.lowerCaseCorrelationFields = correlationFields.stream().map(String::toLowerCase).collect(Collectors.toList());
        this.correlationFields = correlationFields;
    }

    private void onScopeAttached(EventPublishingContextWrapper.ScopeAttachedEvent event) {
        if (log.isTraceEnabled()) {
            log.trace("Got scope attached event [" + event + "]");
        }
        Span span = event.getSpan();
        if (event.getBaggage() != null && span != null && span.getSpanContext().isValid()) {
            this.putEntriesIntoMdc(event.getBaggage());
        }
    }

    private void onScopeRestored(EventPublishingContextWrapper.ScopeRestoredEvent event) {
        if (log.isTraceEnabled()) {
            log.trace("Got scope restored event [" + event + "]");
        }
        if (event.getBaggage() != null) {
            this.putEntriesIntoMdc(event.getBaggage());
        }
    }

    private void putEntriesIntoMdc(Baggage baggage) {
        baggage.forEach((key, baggageEntry) -> {
            if (StringUtils.isNotBlank((String)baggageEntry.getValue()) && this.lowerCaseCorrelationFields.contains(key.toLowerCase())) {
                MDC.put((String)key, (String)baggageEntry.getValue());
            }
        });
    }

    private void onScopeClosed(EventPublishingContextWrapper.ScopeClosedEvent event) {
        if (log.isTraceEnabled()) {
            log.trace("Got scope closed event [" + event + "]");
        }
        this.correlationFields.forEach(MDC::remove);
    }

    @Override
    public void onEvent(Object event) {
        if (event instanceof EventPublishingContextWrapper.ScopeAttachedEvent) {
            this.onScopeAttached((EventPublishingContextWrapper.ScopeAttachedEvent)event);
        } else if (event instanceof EventPublishingContextWrapper.ScopeClosedEvent) {
            this.onScopeClosed((EventPublishingContextWrapper.ScopeClosedEvent)event);
        } else if (event instanceof EventPublishingContextWrapper.ScopeRestoredEvent) {
            this.onScopeRestored((EventPublishingContextWrapper.ScopeRestoredEvent)event);
        }
    }
}

