/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.otel.bridge.OtelTraceContext;
import io.micrometer.tracing.otel.bridge.SpanFromSpanContext;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public class OtelCurrentTraceContext
implements CurrentTraceContext {
    private static final String TRACING_OTEL_CONTEXT_KEY = "otelTraceContext";
    private static final ContextKey<OtelTraceContext> OTEL_CONTEXT_KEY = ContextKey.named((String)"otelTraceContext");

    public TraceContext context() {
        OtelTraceContext otelTraceContext = (OtelTraceContext)Context.current().get(OTEL_CONTEXT_KEY);
        if (otelTraceContext != null) {
            return otelTraceContext;
        }
        Span currentSpan = Span.current();
        if (Span.getInvalid().equals((Object)currentSpan)) {
            return null;
        }
        if (currentSpan instanceof SpanFromSpanContext) {
            return ((SpanFromSpanContext)currentSpan).parentTraceContext;
        }
        return new OtelTraceContext(currentSpan);
    }

    public CurrentTraceContext.Scope newScope(TraceContext context) {
        OtelTraceContext otelTraceContext = (OtelTraceContext)context;
        if (otelTraceContext == null) {
            return new WrappedScope(Scope.noop());
        }
        Context current = Context.current();
        Context oldContext = otelTraceContext.context();
        Span spanFromCurrentCtx = Span.fromContext((Context)current);
        Span spanFromCtxOnNewSpan = Span.fromContext((Context)otelTraceContext.context());
        SpanContext spanContext = otelTraceContext.delegate;
        boolean sameSpan = spanFromCurrentCtx.getSpanContext().equals((Object)spanFromCtxOnNewSpan.getSpanContext()) && spanFromCurrentCtx.getSpanContext().equals((Object)spanContext);
        SpanFromSpanContext fromContext = new SpanFromSpanContext(((OtelTraceContext)context).span, spanContext, otelTraceContext);
        Baggage currentBaggage = Baggage.fromContext((Context)current);
        Baggage oldBaggage = Baggage.fromContext((Context)oldContext);
        boolean sameBaggage = this.sameBaggage(currentBaggage, oldBaggage);
        if (sameSpan && sameBaggage) {
            return new WrappedScope(Scope.noop());
        }
        Baggage updatedBaggage = OtelCurrentTraceContext.mergeBaggage(currentBaggage, oldBaggage);
        Context newContext = oldContext.with((ImplicitContextKeyed)fromContext).with((ImplicitContextKeyed)updatedBaggage).with(OTEL_CONTEXT_KEY, (Object)otelTraceContext);
        Scope newScope = newContext.makeCurrent();
        otelTraceContext.updateContext(newContext);
        return new WrappedScope(newScope, otelTraceContext, oldContext);
    }

    private static Baggage mergeBaggage(Baggage currentBaggage, Baggage oldBaggage) {
        BaggageBuilder baggageBuilder = currentBaggage.toBuilder();
        oldBaggage.forEach((key, baggageEntry) -> baggageBuilder.put(key, baggageEntry.getValue(), baggageEntry.getMetadata()));
        return baggageBuilder.build();
    }

    private boolean sameBaggage(Baggage currentBaggage, Baggage oldBaggage) {
        return currentBaggage.equals((Object)oldBaggage);
    }

    public CurrentTraceContext.Scope maybeScope(TraceContext context) {
        if (context == null) {
            Scope scope = Context.root().makeCurrent();
            return new WrappedScope(scope);
        }
        return this.newScope(context);
    }

    public <C> Callable<C> wrap(Callable<C> task) {
        return Context.current().wrap(task);
    }

    public Runnable wrap(Runnable task) {
        return Context.current().wrap(task);
    }

    public Executor wrap(Executor delegate) {
        return Context.current().wrap(delegate);
    }

    public ExecutorService wrap(ExecutorService delegate) {
        return Context.current().wrap(delegate);
    }

    static class WrappedScope
    implements CurrentTraceContext.Scope {
        final Scope scope;
        final OtelTraceContext currentOtelTraceContext;
        final Context oldContext;

        WrappedScope(Scope scope) {
            this(scope, null, null);
        }

        WrappedScope(Scope scope, OtelTraceContext currentOtelTraceContext, Context oldContext) {
            this.scope = scope;
            this.currentOtelTraceContext = currentOtelTraceContext;
            this.oldContext = oldContext;
        }

        public void close() {
            if (this.currentOtelTraceContext != null) {
                this.currentOtelTraceContext.updateContext(this.oldContext);
            }
            this.scope.close();
        }
    }
}

