/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.brave.bridge;

import brave.Span;
import brave.Tracer;
import brave.propagation.TraceContextOrSamplingFlags;
import io.micrometer.tracing.Link;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.brave.bridge.BraveSpan;
import io.micrometer.tracing.brave.bridge.BraveTraceContext;
import io.micrometer.tracing.brave.bridge.LinkUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class BraveSpanBuilder
implements Span.Builder {
    private final Tracer tracer;
    brave.Span delegate;
    TraceContextOrSamplingFlags parentContext;
    private long startTimestamp;
    private String name;
    private List<String> events = new ArrayList<String>();
    private Map<String, String> tags = new HashMap<String, String>();
    private Throwable error;
    private Span.Kind kind;
    private String remoteServiceName;
    private String ip;
    private int port;

    BraveSpanBuilder(Tracer tracer) {
        this.tracer = tracer;
    }

    BraveSpanBuilder(Tracer tracer, TraceContextOrSamplingFlags parentContext) {
        this.tracer = tracer;
        this.parentContext = parentContext;
    }

    static Span.Builder toBuilder(Tracer tracer, TraceContextOrSamplingFlags context) {
        return new BraveSpanBuilder(tracer, context);
    }

    private brave.Span span() {
        brave.Span span = this.parentContext != null ? this.tracer.nextSpan(this.parentContext) : this.tracer.nextSpan();
        span.name(this.name);
        this.events.forEach(arg_0 -> ((brave.Span)span).annotate(arg_0));
        this.tags.forEach((arg_0, arg_1) -> ((brave.Span)span).tag(arg_0, arg_1));
        span.error(this.error);
        span.kind(this.kind);
        span.remoteServiceName(this.remoteServiceName);
        span.remoteIpAndPort(this.ip, this.port);
        this.delegate = span;
        return span;
    }

    public Span.Builder setParent(TraceContext context) {
        this.parentContext = TraceContextOrSamplingFlags.create((brave.propagation.TraceContext)BraveTraceContext.toBrave(context));
        return this;
    }

    public Span.Builder setNoParent() {
        return this;
    }

    public Span.Builder name(String name) {
        this.name = name;
        return this;
    }

    public Span.Builder event(String value) {
        this.events.add(value);
        return this;
    }

    public Span.Builder tag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public Span.Builder error(Throwable throwable) {
        this.error = throwable;
        return this;
    }

    public Span.Builder kind(Span.Kind kind) {
        this.kind = kind != null ? Span.Kind.valueOf((String)kind.toString()) : null;
        return this;
    }

    public Span.Builder remoteServiceName(String remoteServiceName) {
        this.remoteServiceName = remoteServiceName;
        return this;
    }

    public Span.Builder remoteIpAndPort(String ip, int port) {
        this.ip = ip;
        this.port = port;
        return this;
    }

    public Span.Builder startTimestamp(long startTimestamp, TimeUnit unit) {
        this.startTimestamp = unit.toMicros(startTimestamp);
        return this;
    }

    public Span.Builder addLink(Link link) {
        brave.propagation.TraceContext braveContext = BraveTraceContext.toBrave(link.getTraceContext());
        long nextId = LinkUtils.nextIndex(this.tags);
        this.tags.put(LinkUtils.spanIdKey(nextId), braveContext.spanIdString());
        this.tags.put(LinkUtils.traceIdKey(nextId), braveContext.traceIdString());
        link.getTags().forEach((key, value) -> this.tags.put(LinkUtils.tagKey(nextId, key), String.valueOf(value)));
        return this;
    }

    public Span start() {
        brave.Span span = this.span();
        if (this.startTimestamp > 0L) {
            span.start(this.startTimestamp);
        } else {
            span.start();
        }
        return BraveSpan.fromBrave(span);
    }

    public String toString() {
        return "{ delegate='" + this.delegate + "', parentContext='" + this.parentContext + "', startTimestamp='" + this.startTimestamp + "'}";
    }
}

