/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.brave.bridge;

import brave.handler.MutableSpan;
import io.micrometer.tracing.Link;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.brave.bridge.LinkUtils;
import io.micrometer.tracing.exporter.FinishedSpan;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BraveFinishedSpan
implements FinishedSpan {
    private final MutableSpan mutableSpan;

    public BraveFinishedSpan(MutableSpan mutableSpan) {
        this.mutableSpan = mutableSpan;
    }

    public static FinishedSpan fromBrave(MutableSpan mutableSpan) {
        return new BraveFinishedSpan(mutableSpan);
    }

    public static MutableSpan toBrave(FinishedSpan finishedSpan) {
        return ((BraveFinishedSpan)finishedSpan).mutableSpan;
    }

    public FinishedSpan setName(String name) {
        this.mutableSpan.name(name);
        return this;
    }

    public String getName() {
        return this.mutableSpan.name();
    }

    public Instant getStartTimestamp() {
        return this.microsToInstant(this.mutableSpan.startTimestamp());
    }

    private Instant microsToInstant(long micros) {
        return Instant.EPOCH.plus(micros, ChronoUnit.MICROS);
    }

    public Instant getEndTimestamp() {
        return this.microsToInstant(this.mutableSpan.finishTimestamp());
    }

    public FinishedSpan setTags(Map<String, String> tags) {
        this.mutableSpan.tags().clear();
        tags.forEach((arg_0, arg_1) -> ((MutableSpan)this.mutableSpan).tag(arg_0, arg_1));
        return this;
    }

    public Map<String, String> getTags() {
        return this.mutableSpan.tags();
    }

    public FinishedSpan setEvents(Collection<Map.Entry<Long, String>> events) {
        this.mutableSpan.annotations().clear();
        events.forEach(e -> this.mutableSpan.annotate(((Long)e.getKey()).longValue(), (String)e.getValue()));
        return this;
    }

    public Collection<Map.Entry<Long, String>> getEvents() {
        return this.mutableSpan.annotations();
    }

    public String getSpanId() {
        return this.mutableSpan.id();
    }

    public String getParentId() {
        return this.mutableSpan.parentId();
    }

    public String getRemoteIp() {
        return this.mutableSpan.remoteIp();
    }

    public String getLocalIp() {
        return this.mutableSpan.localIp();
    }

    public FinishedSpan setLocalIp(String ip) {
        this.mutableSpan.localIp(ip);
        return this;
    }

    public int getRemotePort() {
        return this.mutableSpan.remotePort();
    }

    public FinishedSpan setRemotePort(int port) {
        this.mutableSpan.remotePort(port);
        return this;
    }

    public String getTraceId() {
        return this.mutableSpan.traceId();
    }

    public Throwable getError() {
        return this.mutableSpan.error();
    }

    public FinishedSpan setError(Throwable error) {
        this.mutableSpan.error(error);
        return this;
    }

    public Span.Kind getKind() {
        if (this.mutableSpan.kind() == null) {
            return null;
        }
        return Span.Kind.valueOf((String)this.mutableSpan.kind().name());
    }

    public String getRemoteServiceName() {
        return this.mutableSpan.remoteServiceName();
    }

    public FinishedSpan setRemoteServiceName(String remoteServiceName) {
        this.mutableSpan.remoteServiceName(remoteServiceName);
        return this;
    }

    public List<Link> getLinks() {
        ArrayList<Link> links = new ArrayList<Link>();
        this.mutableSpan.tags().entrySet().stream().filter(LinkUtils::isApplicable).collect(Collectors.groupingBy(LinkUtils::linkGroup)).entrySet().stream().filter(e -> (Integer)e.getKey() >= 0).map(Map.Entry::getValue).forEach(e -> {
            Link entry = LinkUtils.toLink(e);
            if (entry != null) {
                links.add(entry);
            }
        });
        return links;
    }

    public FinishedSpan addLinks(List<Link> links) {
        int index = LinkUtils.nextIndex(this.getTags());
        for (Link link : links) {
            this.addLink(index, link);
            ++index;
        }
        return this;
    }

    private void addLink(long index, Link link) {
        TraceContext traceContext = link.getTraceContext();
        Map tags = link.getTags();
        this.mutableSpan.tag(LinkUtils.traceIdKey(index), traceContext.traceId());
        this.mutableSpan.tag(LinkUtils.spanIdKey(index), traceContext.spanId());
        for (Map.Entry e : tags.entrySet()) {
            String key = (String)e.getKey();
            String value = String.valueOf(e.getValue());
            this.mutableSpan.tag(LinkUtils.tagKey(index, key), value);
        }
    }

    public FinishedSpan addLink(Link link) {
        long nextIndex = LinkUtils.nextIndex(this.getTags());
        this.addLink(nextIndex, link);
        return this;
    }

    public String toString() {
        return "BraveFinishedSpan{mutableSpan=" + this.mutableSpan + '}';
    }
}

