/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.brave.bridge;

import brave.Span;
import io.micrometer.observation.transport.Kind;
import io.micrometer.tracing.http.HttpServerRequest;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.ServletRequest;

class BraveHttpServerRequest
implements HttpServerRequest {
    private static final boolean JAVAX_SERVLET_ON_THE_CLASSPATH = BraveHttpServerRequest.isClassPresent("javax.servlet.ServletRequest");
    private static final boolean JAKARTA_SERVLET_ON_THE_CLASSPATH = BraveHttpServerRequest.isClassPresent("jakarta.servlet.ServletRequest");
    final brave.http.HttpServerRequest delegate;

    BraveHttpServerRequest(brave.http.HttpServerRequest delegate) {
        this.delegate = delegate;
    }

    private static boolean isClassPresent(String clazz) {
        try {
            Class.forName(clazz);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static brave.http.HttpServerRequest toBrave(final HttpServerRequest request) {
        if (request == null) {
            return null;
        }
        if (request instanceof BraveHttpServerRequest) {
            return ((BraveHttpServerRequest)request).delegate;
        }
        return new brave.http.HttpServerRequest(){

            public Object unwrap() {
                return request.unwrap();
            }

            public String method() {
                return request.method();
            }

            public String path() {
                return request.path();
            }

            public String url() {
                return request.url();
            }

            public String header(String name) {
                return request.header(name);
            }

            public boolean parseClientIpAndPort(Span span) {
                boolean clientIpAndPortParsed = super.parseClientIpAndPort(span);
                if (clientIpAndPortParsed) {
                    return true;
                }
                return this.resolveFromInetAddress(span);
            }

            private boolean resolveFromInetAddress(Span span) {
                Object delegate = request.unwrap();
                if (JAVAX_SERVLET_ON_THE_CLASSPATH && delegate instanceof ServletRequest) {
                    ServletRequest servletRequest = (ServletRequest)delegate;
                    String addr = servletRequest.getRemoteAddr();
                    if (addr == null) {
                        return false;
                    }
                    return span.remoteIpAndPort(addr, servletRequest.getRemotePort());
                }
                if (JAKARTA_SERVLET_ON_THE_CLASSPATH && delegate instanceof jakarta.servlet.ServletRequest) {
                    jakarta.servlet.ServletRequest servletRequest = (jakarta.servlet.ServletRequest)delegate;
                    String addr = servletRequest.getRemoteAddr();
                    if (addr == null) {
                        return false;
                    }
                    return span.remoteIpAndPort(addr, servletRequest.getRemotePort());
                }
                return false;
            }
        };
    }

    public String method() {
        return this.delegate.method();
    }

    public String route() {
        return this.delegate.route();
    }

    public Object unwrap() {
        return this.delegate.unwrap();
    }

    public Collection<String> headerNames() {
        return Collections.emptyList();
    }

    public Kind kind() {
        return Kind.valueOf((String)this.delegate.spanKind().name());
    }

    public String path() {
        return this.delegate.path();
    }

    public String url() {
        return this.delegate.url();
    }

    public String header(String name) {
        return this.delegate.header(name);
    }
}

