/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.stackdriver;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.monitoring.v3.MetricServiceSettings;
import io.micrometer.core.instrument.config.MissingRequiredConfigurationException;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public interface StackdriverConfig
extends StepRegistryConfig {
    default public String prefix() {
        return "stackdriver";
    }

    default public String projectId() {
        String v = this.get(this.prefix() + ".projectId");
        if (v == null) {
            throw new MissingRequiredConfigurationException("projectId must be set to report metrics to Stackdriver");
        }
        return v;
    }

    default public Map<String, String> resourceLabels() {
        return Collections.emptyMap();
    }

    default public String resourceType() {
        String resourceType = this.get(this.prefix() + ".resourceType");
        return resourceType == null ? "global" : resourceType;
    }

    default public CredentialsProvider credentials() throws IOException {
        String credentials = this.get(this.prefix() + ".credentials");
        return credentials == null ? MetricServiceSettings.defaultCredentialsProviderBuilder().build() : FixedCredentialsProvider.create((Credentials)GoogleCredentials.fromStream((InputStream)new FileInputStream(credentials)).createScoped((Collection)MetricServiceSettings.getDefaultServiceScopes()));
    }
}

