/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.stackdriver;

import com.google.api.gax.rpc.HeaderProvider;
import java.util.Collections;
import java.util.Map;

class UserAgentHeaderProvider
implements HeaderProvider {
    private final Map<String, String> headers;

    UserAgentHeaderProvider(String component) {
        String userAgent = this.computeUserAgent(component);
        this.headers = Collections.singletonMap("User-Agent", userAgent);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    private String computeUserAgent(String component) {
        String library = "micrometer-registry-" + component;
        String version = this.getClass().getPackage().getImplementationVersion();
        return "Micrometer/" + version + " " + library + "/" + version;
    }
}

