/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.stackdriver;

import com.google.api.Distribution;
import com.google.api.Metric;
import com.google.api.MetricDescriptor;
import com.google.api.MonitoredResource;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.monitoring.v3.MetricServiceSettings;
import com.google.monitoring.v3.CreateMetricDescriptorRequest;
import com.google.monitoring.v3.CreateTimeSeriesRequest;
import com.google.monitoring.v3.Point;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.TimeInterval;
import com.google.monitoring.v3.TimeSeries;
import com.google.monitoring.v3.TypedValue;
import com.google.protobuf.Timestamp;
import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MissingRequiredConfigurationException;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.HistogramSupport;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.step.StepDistributionSummary;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.step.StepTimer;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.lang.Nullable;
import io.micrometer.stackdriver.StackdriverConfig;
import io.micrometer.stackdriver.StackdriverNamingConvention;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Incubating(since="1.1.0")
public class StackdriverMeterRegistry
extends StepMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("stackdriver-metrics-publisher");
    private static final String RESOURCE_TYPE = "global";
    private static final int TIMESERIES_PER_REQUEST_LIMIT = 200;
    private final Logger logger = LoggerFactory.getLogger(StackdriverMeterRegistry.class);
    private final StackdriverConfig config;
    private final Set<String> verifiedDescriptors = ConcurrentHashMap.newKeySet();
    @Nullable
    private MetricServiceSettings metricServiceSettings;
    @Nullable
    private MetricServiceClient client;

    public StackdriverMeterRegistry(StackdriverConfig config, Clock clock) {
        this(config, clock, DEFAULT_THREAD_FACTORY, () -> MetricServiceSettings.newBuilder().build());
    }

    private StackdriverMeterRegistry(StackdriverConfig config, Clock clock, ThreadFactory threadFactory, Callable<MetricServiceSettings> metricServiceSettings) {
        super((StepRegistryConfig)config, clock);
        if (config.projectId() == null) {
            throw new MissingRequiredConfigurationException("projectId must be set to report metrics to Stackdriver");
        }
        this.config = config;
        try {
            this.metricServiceSettings = metricServiceSettings.call();
        }
        catch (Exception e) {
            this.logger.error("unable to create stackdriver service settings", (Throwable)e);
        }
        this.config().namingConvention((NamingConvention)new StackdriverNamingConvention());
        this.start(threadFactory);
    }

    public static Builder builder(StackdriverConfig config) {
        return new Builder(config);
    }

    public void start(ThreadFactory threadFactory) {
        if (this.config.enabled()) {
            if (this.metricServiceSettings == null) {
                this.logger.error("unable to start stackdriver, service settings are not available");
            } else {
                try {
                    this.client = MetricServiceClient.create((MetricServiceSettings)this.metricServiceSettings);
                    this.logger.info("publishing metrics to stackdriver every " + TimeUtils.format((Duration)this.config.step()));
                    super.start(threadFactory);
                }
                catch (Exception e) {
                    this.logger.error("unable to create stackdriver client", (Throwable)e);
                }
            }
        }
    }

    public void stop() {
        if (this.client != null) {
            this.client.shutdownNow();
        }
        super.stop();
    }

    protected void publish() {
        if (this.client == null) {
            return;
        }
        Batch publishBatch = new Batch();
        AtomicLong partitioningCounter = new AtomicLong();
        long partitionSize = Math.min(this.config.batchSize(), 200);
        Collection<List<TimeSeries>> series = this.getMeters().stream().flatMap(meter -> (Stream)meter.match(m -> this.createGauge(publishBatch, (Gauge)m), m -> this.createCounter(publishBatch, (Counter)m), m -> this.createTimer(publishBatch, (Timer)m), m -> this.createSummary(publishBatch, (DistributionSummary)m), m -> this.createLongTaskTimer(publishBatch, (LongTaskTimer)m), m -> this.createTimeGauge(publishBatch, (TimeGauge)m), m -> this.createFunctionCounter(publishBatch, (FunctionCounter)m), m -> this.createFunctionTimer(publishBatch, (FunctionTimer)m), m -> this.createMeter(publishBatch, (Meter)m))).collect(Collectors.groupingBy(o -> partitioningCounter.incrementAndGet() / partitionSize)).values();
        for (List<TimeSeries> partition : series) {
            try {
                CreateTimeSeriesRequest request = CreateTimeSeriesRequest.newBuilder().setName("projects/" + this.config.projectId()).addAllTimeSeries(partition).build();
                this.logger.trace("publishing batch to Stackdriver:{}{}", (Object)System.lineSeparator(), (Object)request);
                this.client.createTimeSeries(request);
                this.logger.debug("successfully sent {} TimeSeries to Stackdriver", (Object)partition.size());
            }
            catch (ApiException e) {
                this.logger.warn("failed to send metrics to Stackdriver", (Throwable)e);
            }
        }
    }

    private Stream<TimeSeries> createMeter(Batch batch, Meter m) {
        return StreamSupport.stream(m.measure().spliterator(), false).map(ms -> batch.createTimeSeries(m, ms.getValue(), ms.getStatistic().getTagValueRepresentation()));
    }

    private Stream<TimeSeries> createFunctionTimer(Batch batch, FunctionTimer timer) {
        long count = (long)timer.count();
        Distribution.Builder distribution = Distribution.newBuilder().setMean(timer.mean(this.getBaseTimeUnit())).setCount(count).setBucketOptions(Distribution.BucketOptions.newBuilder().setExplicitBuckets(Distribution.BucketOptions.Explicit.newBuilder().addBounds(0.0).build())).addBucketCounts(0L).addBucketCounts(count);
        return Stream.of(batch.createTimeSeries((Meter)timer, distribution.build()));
    }

    private Stream<TimeSeries> createFunctionCounter(Batch batch, FunctionCounter functionCounter) {
        return Stream.of(batch.createTimeSeries((Meter)functionCounter, functionCounter.count(), null));
    }

    private Stream<TimeSeries> createTimeGauge(Batch batch, TimeGauge timeGauge) {
        return Stream.of(batch.createTimeSeries((Meter)timeGauge, timeGauge.value(this.getBaseTimeUnit()), null));
    }

    private Stream<TimeSeries> createSummary(Batch batch, DistributionSummary summary) {
        return batch.createTimeSeries((HistogramSupport)summary, false);
    }

    private Stream<TimeSeries> createTimer(Batch batch, Timer timer) {
        return batch.createTimeSeries((HistogramSupport)timer, true);
    }

    private Stream<TimeSeries> createGauge(Batch batch, Gauge gauge) {
        return Stream.of(batch.createTimeSeries((Meter)gauge, gauge.value(), null));
    }

    private Stream<TimeSeries> createCounter(Batch batch, Counter counter) {
        return Stream.of(batch.createTimeSeries((Meter)counter, counter.count(), null));
    }

    private Stream<TimeSeries> createLongTaskTimer(Batch batch, LongTaskTimer longTaskTimer) {
        return Stream.of(batch.createTimeSeries((Meter)longTaskTimer, longTaskTimer.activeTasks(), "activeTasks"), batch.createTimeSeries((Meter)longTaskTimer, longTaskTimer.duration(this.getBaseTimeUnit()), "duration"));
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        return new StepDistributionSummary(id, this.clock, distributionStatisticConfig, scale, this.config.step().toMillis(), true);
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        return new StepTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit(), this.config.step().toMillis(), true);
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    static /* synthetic */ ThreadFactory access$100() {
        return DEFAULT_THREAD_FACTORY;
    }

    private class Batch {
        private final TimeInterval interval;

        private Batch() {
            this.interval = TimeInterval.newBuilder().setEndTime(Timestamp.newBuilder().setSeconds(StackdriverMeterRegistry.this.clock.wallTime() / 1000L).setNanos((int)(StackdriverMeterRegistry.this.clock.wallTime() % 1000L) * 1000000).build()).build();
        }

        TimeSeries createTimeSeries(Meter meter, double value, @Nullable String statistic) {
            return this.createTimeSeries(meter.getId(), TypedValue.newBuilder().setDoubleValue(value).build(), MetricDescriptor.ValueType.DOUBLE, statistic);
        }

        TimeSeries createTimeSeries(Meter meter, long value, @Nullable String statistic) {
            return this.createTimeSeries(meter.getId(), TypedValue.newBuilder().setInt64Value(value).build(), MetricDescriptor.ValueType.INT64, statistic);
        }

        Stream<TimeSeries> createTimeSeries(HistogramSupport histogramSupport, boolean timeDomain) {
            HistogramSnapshot snapshot = histogramSupport.takeSnapshot();
            return Stream.concat(Stream.of(this.createTimeSeries((Meter)histogramSupport, this.distribution(snapshot, timeDomain)), this.createTimeSeries((Meter)histogramSupport, timeDomain ? snapshot.max(StackdriverMeterRegistry.this.getBaseTimeUnit()) : snapshot.max(), "max"), this.createTimeSeries((Meter)histogramSupport, snapshot.count(), "count")), Arrays.stream(snapshot.percentileValues()).map(valueAtP -> this.createTimeSeries((Meter)histogramSupport, timeDomain ? valueAtP.value(StackdriverMeterRegistry.this.getBaseTimeUnit()) : valueAtP.value(), "p" + DoubleFormat.decimalOrWhole((double)(valueAtP.percentile() * 100.0)))));
        }

        TimeSeries createTimeSeries(Meter meter, Distribution distribution) {
            return this.createTimeSeries(meter.getId(), TypedValue.newBuilder().setDistributionValue(distribution).build(), MetricDescriptor.ValueType.DISTRIBUTION, null);
        }

        private TimeSeries createTimeSeries(Meter.Id id, TypedValue typedValue, MetricDescriptor.ValueType valueType, @Nullable String statistic) {
            if (StackdriverMeterRegistry.this.client != null) {
                this.createMetricDescriptorIfNecessary(StackdriverMeterRegistry.this.client, id, valueType, statistic);
            }
            String metricType = this.metricType(id, statistic);
            Map<String, String> metricLabels = StackdriverMeterRegistry.this.getConventionTags(id).stream().collect(Collectors.toMap(Tag::getKey, Tag::getValue));
            return TimeSeries.newBuilder().setMetric(Metric.newBuilder().setType(metricType).putAllLabels(metricLabels).build()).setResource(MonitoredResource.newBuilder().setType(StackdriverMeterRegistry.RESOURCE_TYPE).putLabels("project_id", StackdriverMeterRegistry.this.config.projectId()).build()).setMetricKind(MetricDescriptor.MetricKind.GAUGE).setValueType(valueType).addPoints(Point.newBuilder().setInterval(this.interval).setValue(typedValue).build()).build();
        }

        private void createMetricDescriptorIfNecessary(MetricServiceClient client, Meter.Id id, MetricDescriptor.ValueType valueType, @Nullable String statistic) {
            if (!StackdriverMeterRegistry.this.verifiedDescriptors.contains(id.getName())) {
                MetricDescriptor descriptor = MetricDescriptor.newBuilder().setType(this.metricType(id, statistic)).setDescription(id.getDescription() == null ? "" : id.getDescription()).setMetricKind(MetricDescriptor.MetricKind.GAUGE).setValueType(valueType).build();
                ProjectName name = ProjectName.of((String)StackdriverMeterRegistry.this.config.projectId());
                CreateMetricDescriptorRequest request = CreateMetricDescriptorRequest.newBuilder().setName(name.toString()).setMetricDescriptor(descriptor).build();
                StackdriverMeterRegistry.this.logger.trace("creating metric descriptor:{}{}", (Object)System.lineSeparator(), (Object)request);
                try {
                    client.createMetricDescriptor(request);
                    StackdriverMeterRegistry.this.verifiedDescriptors.add(id.getName());
                }
                catch (ApiException e) {
                    StackdriverMeterRegistry.this.logger.warn("failed to create metric descriptor in Stackdriver for meter " + id, (Throwable)e);
                }
            }
        }

        private String metricType(Meter.Id id, @Nullable String statistic) {
            StringBuilder metricType = new StringBuilder("custom.googleapis.com/").append(StackdriverMeterRegistry.this.getConventionName(id));
            if (statistic != null) {
                metricType.append("/").append(statistic);
            }
            return metricType.toString();
        }

        private Distribution distribution(HistogramSnapshot snapshot, boolean timeDomain) {
            int endIndex;
            CountAtBucket[] histogram = snapshot.histogramCounts();
            AtomicLong truncatedSum = new AtomicLong();
            AtomicReference<Double> last = new AtomicReference<Double>(0.0);
            List<Long> bucketCounts = Arrays.stream(histogram).map(countAtBucket -> {
                double cumulativeCount = countAtBucket.count();
                long bucketCount = (long)(cumulativeCount - last.getAndSet(cumulativeCount));
                truncatedSum.addAndGet(bucketCount);
                return bucketCount;
            }).collect(Collectors.toCollection(ArrayList::new));
            if (!bucketCounts.isEmpty() && (Long)bucketCounts.get(endIndex = bucketCounts.size() - 1) == 0L) {
                int lastNonZeroIndex = 0;
                for (int i = endIndex - 1; i >= 0; --i) {
                    if ((Long)bucketCounts.get(i) <= 0L) continue;
                    lastNonZeroIndex = i;
                    break;
                }
                bucketCounts = bucketCounts.subList(0, lastNonZeroIndex + 1);
            }
            bucketCounts.add(snapshot.count() - truncatedSum.get());
            List<Double> bucketBoundaries = Arrays.stream(histogram).map(countAtBucket -> timeDomain ? countAtBucket.bucket(StackdriverMeterRegistry.this.getBaseTimeUnit()) : (double)countAtBucket.bucket()).collect(Collectors.toCollection(ArrayList::new));
            if (bucketBoundaries.size() != bucketCounts.size() - 1) {
                bucketBoundaries = bucketBoundaries.subList(0, bucketCounts.size() - 1);
            }
            if (bucketBoundaries.isEmpty()) {
                bucketBoundaries.add(0.0);
            }
            return Distribution.newBuilder().setMean(timeDomain ? snapshot.mean(StackdriverMeterRegistry.this.getBaseTimeUnit()) : snapshot.mean()).setCount(snapshot.count()).setBucketOptions(Distribution.BucketOptions.newBuilder().setExplicitBuckets(Distribution.BucketOptions.Explicit.newBuilder().addAllBounds(bucketBoundaries).build()).build()).addAllBucketCounts(bucketCounts).build();
        }
    }

    public static class Builder {
        private final StackdriverConfig config;
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = StackdriverMeterRegistry.access$100();
        private Callable<MetricServiceSettings> metricServiceSettings = () -> MetricServiceSettings.newBuilder().build();

        Builder(StackdriverConfig config) {
            this.config = config;
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder metricServiceSettings(Callable<MetricServiceSettings> metricServiceSettings) {
            this.metricServiceSettings = metricServiceSettings;
            return this;
        }

        public StackdriverMeterRegistry build() {
            return new StackdriverMeterRegistry(this.config, this.clock, this.threadFactory, this.metricServiceSettings);
        }
    }
}

