/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.signalfx;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import io.micrometer.core.instrument.util.StringUtils;
import io.micrometer.core.lang.Nullable;
import io.micrometer.core.util.internal.logging.WarnThenDebugLogger;
import java.util.regex.Pattern;

public class SignalFxNamingConvention
implements NamingConvention {
    private static final WarnThenDebugLogger logger = new WarnThenDebugLogger(SignalFxNamingConvention.class);
    private static final Pattern START_UNDERSCORE_PATTERN = Pattern.compile("^_");
    private static final Pattern SF_PATTERN = Pattern.compile("^sf_");
    private static final Pattern START_LETTERS_PATTERN = Pattern.compile("^[a-zA-Z].*");
    private static final Pattern PATTERN_TAG_KEY_DENYLISTED_CHARS = Pattern.compile("[^\\w_\\-]");
    private static final Pattern PATTERN_TAG_KEY_DENYLISTED_PREFIX = Pattern.compile("^(aws|gcp|azure)_.*");
    private static final int NAME_MAX_LENGTH = 256;
    private static final int TAG_VALUE_MAX_LENGTH = 256;
    private static final int KEY_MAX_LENGTH = 128;
    private final NamingConvention delegate;

    public SignalFxNamingConvention() {
        this(NamingConvention.dot);
    }

    public SignalFxNamingConvention(NamingConvention delegate) {
        this.delegate = delegate;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        String formattedName = StringEscapeUtils.escapeJson((String)this.delegate.name(name, type, baseUnit));
        return StringUtils.truncate((String)formattedName, (int)256);
    }

    public String tagKey(String key) {
        String conventionKey = this.delegate.tagKey(key);
        conventionKey = START_UNDERSCORE_PATTERN.matcher(conventionKey).replaceAll("");
        conventionKey = SF_PATTERN.matcher(conventionKey).replaceAll("");
        if (!START_LETTERS_PATTERN.matcher(conventionKey = PATTERN_TAG_KEY_DENYLISTED_CHARS.matcher(conventionKey).replaceAll("_")).matches()) {
            conventionKey = "a" + conventionKey;
        }
        if (PATTERN_TAG_KEY_DENYLISTED_PREFIX.matcher(conventionKey).matches()) {
            String finalConventionKey = conventionKey;
            logger.log(() -> "'" + finalConventionKey + "' (original name: '" + key + "') is not a valid tag key. Must not start with any of these prefixes: aws_, gcp_, or azure_. Please rename it to conform to the constraints. If it comes from a third party, please use MeterFilter to rename it.");
        }
        return StringUtils.truncate((String)conventionKey, (int)128);
    }

    public String tagValue(String value) {
        String formattedValue = StringEscapeUtils.escapeJson((String)this.delegate.tagValue(value));
        return StringUtils.truncate((String)formattedValue, (int)256);
    }
}

