/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.signalfx;

import com.signalfx.endpoint.SignalFxEndpoint;
import com.signalfx.endpoint.SignalFxReceiverEndpoint;
import com.signalfx.metrics.auth.AuthToken;
import com.signalfx.metrics.auth.StaticAuthToken;
import com.signalfx.metrics.connection.DataPointReceiverFactory;
import com.signalfx.metrics.connection.EventReceiverFactory;
import com.signalfx.metrics.connection.HttpDataPointProtobufReceiverFactory;
import com.signalfx.metrics.connection.HttpEventProtobufReceiverFactory;
import com.signalfx.metrics.errorhandler.OnSendErrorHandler;
import com.signalfx.metrics.flush.AggregateMetricSender;
import com.signalfx.metrics.protobuf.SignalFxProtocolBuffers;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MissingRequiredConfigurationException;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.lang.Nullable;
import io.micrometer.signalfx.SignalFxConfig;
import io.micrometer.signalfx.SignalFxNamingConvention;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalFxMeterRegistry
extends StepMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("signalfx-metrics-publisher");
    private final Logger logger = LoggerFactory.getLogger(SignalFxMeterRegistry.class);
    private final SignalFxConfig config;
    private final HttpDataPointProtobufReceiverFactory dataPointReceiverFactory;
    private final HttpEventProtobufReceiverFactory eventReceiverFactory;
    private final Set<OnSendErrorHandler> onSendErrorHandlerCollection = Collections.singleton(metricError -> this.logger.warn("failed to send metrics: {}", (Object)metricError.getMessage()));

    public SignalFxMeterRegistry(SignalFxConfig config, Clock clock) {
        this(config, clock, DEFAULT_THREAD_FACTORY);
    }

    public SignalFxMeterRegistry(SignalFxConfig config, Clock clock, ThreadFactory threadFactory) {
        super((StepRegistryConfig)config, clock);
        this.config = config;
        if (config.accessToken() == null) {
            throw new MissingRequiredConfigurationException("accessToken must be set to report metrics to SignalFX");
        }
        URI apiUri = URI.create(config.uri());
        int port = apiUri.getPort();
        if (port == -1) {
            if ("http".equals(apiUri.getScheme())) {
                port = 80;
            } else if ("https".equals(apiUri.getScheme())) {
                port = 443;
            }
        }
        SignalFxEndpoint signalFxEndpoint = new SignalFxEndpoint(apiUri.getScheme(), apiUri.getHost(), port);
        this.dataPointReceiverFactory = new HttpDataPointProtobufReceiverFactory((SignalFxReceiverEndpoint)signalFxEndpoint);
        this.eventReceiverFactory = new HttpEventProtobufReceiverFactory((SignalFxReceiverEndpoint)signalFxEndpoint);
        this.config().namingConvention((NamingConvention)new SignalFxNamingConvention());
        this.start(threadFactory);
    }

    public void start(ThreadFactory threadFactory) {
        if (this.config.enabled()) {
            this.logger.info("publishing metrics to signalfx every " + TimeUtils.format((Duration)this.config.step()));
        }
        super.start(threadFactory);
    }

    protected void publish() {
        long timestamp = this.clock.wallTime();
        AggregateMetricSender metricSender = new AggregateMetricSender(this.config.source(), (DataPointReceiverFactory)this.dataPointReceiverFactory, (EventReceiverFactory)this.eventReceiverFactory, (AuthToken)new StaticAuthToken(this.config.accessToken()), this.onSendErrorHandlerCollection);
        for (List batch : MeterPartition.partition((MeterRegistry)this, (int)this.config.batchSize())) {
            try {
                AggregateMetricSender.Session session = metricSender.createSession();
                try {
                    batch.stream().map(meter -> (Stream)meter.match(this::addGauge, this::addCounter, this::addTimer, this::addDistributionSummary, this::addLongTaskTimer, this::addTimeGauge, this::addFunctionCounter, this::addFunctionTimer, this::addMeter)).flatMap(builders -> builders.map(builder -> builder.setTimestamp(timestamp).build())).forEach(arg_0 -> ((AggregateMetricSender.Session)session).setDatapoint(arg_0));
                    this.logger.debug("successfully sent {} metrics to SignalFx.", (Object)batch.size());
                }
                finally {
                    if (session == null) continue;
                    session.close();
                }
            }
            catch (Throwable e) {
                this.logger.warn("failed to send metrics", e);
            }
        }
    }

    private Stream<SignalFxProtocolBuffers.DataPoint.Builder> addMeter(Meter meter) {
        return StreamSupport.stream(meter.measure().spliterator(), false).flatMap(measurement -> {
            String statSuffix = NamingConvention.camelCase.tagKey(measurement.getStatistic().toString());
            switch (measurement.getStatistic()) {
                case TOTAL: 
                case TOTAL_TIME: 
                case COUNT: 
                case DURATION: {
                    return Stream.of(this.addDatapoint(meter, SignalFxProtocolBuffers.MetricType.COUNTER, statSuffix, measurement.getValue()));
                }
                case MAX: 
                case VALUE: 
                case UNKNOWN: 
                case ACTIVE_TASKS: {
                    return Stream.of(this.addDatapoint(meter, SignalFxProtocolBuffers.MetricType.GAUGE, statSuffix, measurement.getValue()));
                }
            }
            return Stream.empty();
        });
    }

    private SignalFxProtocolBuffers.DataPoint.Builder addDatapoint(Meter meter, SignalFxProtocolBuffers.MetricType metricType, @Nullable String statSuffix, Number value) {
        SignalFxProtocolBuffers.Datum.Builder datumBuilder = SignalFxProtocolBuffers.Datum.newBuilder();
        SignalFxProtocolBuffers.Datum datum = (value instanceof Double ? datumBuilder.setDoubleValue(((Double)value).doubleValue()) : datumBuilder.setIntValue(value.longValue())).build();
        String metricName = this.config().namingConvention().name(statSuffix == null ? meter.getId().getName() : meter.getId().getName() + "." + statSuffix, meter.getId().getType(), meter.getId().getBaseUnit());
        SignalFxProtocolBuffers.DataPoint.Builder dataPointBuilder = SignalFxProtocolBuffers.DataPoint.newBuilder().setMetric(metricName).setMetricType(metricType).setValue(datum);
        for (Tag tag : this.getConventionTags(meter.getId())) {
            dataPointBuilder.addDimensions(SignalFxProtocolBuffers.Dimension.newBuilder().setKey(tag.getKey()).setValue(tag.getValue()).build());
        }
        return dataPointBuilder;
    }

    Stream<SignalFxProtocolBuffers.DataPoint.Builder> addLongTaskTimer(LongTaskTimer longTaskTimer) {
        return Stream.of(this.addDatapoint((Meter)longTaskTimer, SignalFxProtocolBuffers.MetricType.GAUGE, "activeTasks", longTaskTimer.activeTasks()), this.addDatapoint((Meter)longTaskTimer, SignalFxProtocolBuffers.MetricType.COUNTER, "duration", longTaskTimer.duration(this.getBaseTimeUnit())));
    }

    private Stream<SignalFxProtocolBuffers.DataPoint.Builder> addTimeGauge(TimeGauge timeGauge) {
        return Stream.of(this.addDatapoint((Meter)timeGauge, SignalFxProtocolBuffers.MetricType.GAUGE, null, timeGauge.value(this.getBaseTimeUnit())));
    }

    private Stream<SignalFxProtocolBuffers.DataPoint.Builder> addGauge(Gauge gauge) {
        return Stream.of(this.addDatapoint((Meter)gauge, SignalFxProtocolBuffers.MetricType.GAUGE, null, gauge.value()));
    }

    private Stream<SignalFxProtocolBuffers.DataPoint.Builder> addCounter(Counter counter) {
        return Stream.of(this.addDatapoint((Meter)counter, SignalFxProtocolBuffers.MetricType.COUNTER, null, counter.count()));
    }

    private Stream<SignalFxProtocolBuffers.DataPoint.Builder> addFunctionCounter(FunctionCounter counter) {
        return Stream.of(this.addDatapoint((Meter)counter, SignalFxProtocolBuffers.MetricType.COUNTER, null, counter.count()));
    }

    private Stream<SignalFxProtocolBuffers.DataPoint.Builder> addTimer(Timer timer) {
        return Stream.of(this.addDatapoint((Meter)timer, SignalFxProtocolBuffers.MetricType.COUNTER, "count", timer.count()), this.addDatapoint((Meter)timer, SignalFxProtocolBuffers.MetricType.COUNTER, "totalTime", timer.totalTime(this.getBaseTimeUnit())), this.addDatapoint((Meter)timer, SignalFxProtocolBuffers.MetricType.GAUGE, "avg", timer.mean(this.getBaseTimeUnit())), this.addDatapoint((Meter)timer, SignalFxProtocolBuffers.MetricType.GAUGE, "max", timer.max(this.getBaseTimeUnit())));
    }

    private Stream<SignalFxProtocolBuffers.DataPoint.Builder> addFunctionTimer(FunctionTimer timer) {
        return Stream.of(this.addDatapoint((Meter)timer, SignalFxProtocolBuffers.MetricType.COUNTER, "count", timer.count()), this.addDatapoint((Meter)timer, SignalFxProtocolBuffers.MetricType.COUNTER, "totalTime", timer.totalTime(this.getBaseTimeUnit())), this.addDatapoint((Meter)timer, SignalFxProtocolBuffers.MetricType.GAUGE, "avg", timer.mean(this.getBaseTimeUnit())));
    }

    private Stream<SignalFxProtocolBuffers.DataPoint.Builder> addDistributionSummary(DistributionSummary summary) {
        return Stream.of(this.addDatapoint((Meter)summary, SignalFxProtocolBuffers.MetricType.COUNTER, "count", summary.count()), this.addDatapoint((Meter)summary, SignalFxProtocolBuffers.MetricType.COUNTER, "totalTime", summary.totalAmount()), this.addDatapoint((Meter)summary, SignalFxProtocolBuffers.MetricType.GAUGE, "avg", summary.mean()), this.addDatapoint((Meter)summary, SignalFxProtocolBuffers.MetricType.GAUGE, "max", summary.max()));
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }
}

