/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.signalfx;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.TimeWindowMax;
import io.micrometer.core.instrument.step.StepTuple2;
import io.micrometer.signalfx.CumulativeHistogramConfigUtil;
import io.micrometer.signalfx.DeltaHistogramCounts;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

final class SignalfxDistributionSummary
extends AbstractDistributionSummary {
    private final LongAdder count = new LongAdder();
    private final DoubleAdder total = new DoubleAdder();
    private final StepTuple2<Long, Double> countTotal;
    private final TimeWindowMax max;
    @Nullable
    private final DeltaHistogramCounts deltaHistogramCounts;

    SignalfxDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale, long stepMillis, boolean isDelta) {
        super(id, clock, CumulativeHistogramConfigUtil.updateConfig(distributionStatisticConfig), scale, false);
        this.countTotal = new StepTuple2(clock, stepMillis, (Object)0L, (Object)0.0, this.count::sumThenReset, this.total::sumThenReset);
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
        this.deltaHistogramCounts = distributionStatisticConfig.isPublishingHistogram() && isDelta ? new DeltaHistogramCounts() : null;
    }

    protected void recordNonNegative(double amount) {
        this.count.increment();
        this.total.add(amount);
        this.max.record(amount);
    }

    public long count() {
        return (Long)this.countTotal.poll1();
    }

    public double totalAmount() {
        return (Double)this.countTotal.poll2();
    }

    public double max() {
        return this.max.poll();
    }

    public HistogramSnapshot takeSnapshot() {
        HistogramSnapshot currentSnapshot = super.takeSnapshot();
        if (this.deltaHistogramCounts == null) {
            return currentSnapshot;
        }
        return new HistogramSnapshot(currentSnapshot.count(), currentSnapshot.total(), currentSnapshot.max(), currentSnapshot.percentileValues(), this.deltaHistogramCounts.calculate(currentSnapshot.histogramCounts()), (arg_0, arg_1) -> ((HistogramSnapshot)currentSnapshot).outputSummary(arg_0, arg_1));
    }
}

