/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.signalfx;

import com.signalfx.endpoint.SignalFxEndpoint;
import com.signalfx.endpoint.SignalFxReceiverEndpoint;
import com.signalfx.metrics.auth.AuthToken;
import com.signalfx.metrics.auth.StaticAuthToken;
import com.signalfx.metrics.connection.DataPointReceiverFactory;
import com.signalfx.metrics.connection.EventReceiverFactory;
import com.signalfx.metrics.connection.HttpDataPointProtobufReceiverFactory;
import com.signalfx.metrics.connection.HttpEventProtobufReceiverFactory;
import com.signalfx.metrics.flush.AggregateMetricSender;
import com.signalfx.metrics.protobuf.SignalFxProtocolBuffers;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.HistogramSnapshot;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.ValueAtPercentile;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.lang.Nullable;
import io.micrometer.signalfx.SignalFxConfig;
import io.micrometer.signalfx.SignalFxNamingConvention;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalFxMeterRegistry
extends StepMeterRegistry {
    private final Logger logger = LoggerFactory.getLogger(SignalFxMeterRegistry.class);
    private final SignalFxConfig config;
    private final AggregateMetricSender metricSender;

    public SignalFxMeterRegistry(SignalFxConfig config, Clock clock) {
        this(config, clock, Executors.defaultThreadFactory());
    }

    public SignalFxMeterRegistry(SignalFxConfig config, Clock clock, ThreadFactory threadFactory) {
        super((StepRegistryConfig)config, clock);
        this.config = config;
        URI apiUri = URI.create(config.uri());
        int port = apiUri.getPort();
        if (port == -1) {
            if ("http".equals(apiUri.getScheme())) {
                port = 80;
            } else if ("https".equals(apiUri.getScheme())) {
                port = 443;
            }
        }
        SignalFxEndpoint signalFxEndpoint = new SignalFxEndpoint(apiUri.getScheme(), apiUri.getHost(), port);
        this.metricSender = new AggregateMetricSender("test.SendMetrics", (DataPointReceiverFactory)new HttpDataPointProtobufReceiverFactory((SignalFxReceiverEndpoint)signalFxEndpoint).setVersion(2), (EventReceiverFactory)new HttpEventProtobufReceiverFactory((SignalFxReceiverEndpoint)signalFxEndpoint), (AuthToken)new StaticAuthToken(config.accessToken()), Collections.singleton(metricError -> this.logger.warn("failed to send metrics: " + metricError.getMessage())));
        this.config().namingConvention((NamingConvention)new SignalFxNamingConvention());
        this.start(threadFactory);
    }

    protected void publish() {
        long timestamp = this.clock.wallTime();
        for (List batch : MeterPartition.partition((MeterRegistry)this, (int)this.config.batchSize())) {
            try {
                AggregateMetricSender.Session session = this.metricSender.createSession();
                Throwable throwable = null;
                try {
                    for (Meter meter : batch) {
                        if (meter instanceof Counter) {
                            this.addCounter((Counter)meter, session, timestamp);
                            continue;
                        }
                        if (meter instanceof Timer) {
                            this.addTimer((Timer)meter, session, timestamp);
                            continue;
                        }
                        if (meter instanceof DistributionSummary) {
                            this.addDistributionSummary((DistributionSummary)meter, session, timestamp);
                            continue;
                        }
                        if (meter instanceof TimeGauge) {
                            this.addTimeGauge((TimeGauge)meter, session, timestamp);
                            continue;
                        }
                        if (meter instanceof Gauge) {
                            this.addGauge((Gauge)meter, session, timestamp);
                            continue;
                        }
                        if (meter instanceof FunctionTimer) {
                            this.addFunctionTimer((FunctionTimer)meter, session, timestamp);
                            continue;
                        }
                        if (meter instanceof FunctionCounter) {
                            this.addFunctionCounter((FunctionCounter)meter, session, timestamp);
                            continue;
                        }
                        if (meter instanceof LongTaskTimer) {
                            this.addLongTaskTimer((LongTaskTimer)meter, session, timestamp);
                            continue;
                        }
                        this.addMeter(meter, session, timestamp);
                    }
                    this.logger.info("successfully sent " + batch.size() + " metrics to Signalfx");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (session == null) continue;
                    if (throwable != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    session.close();
                }
            }
            catch (Throwable e) {
                this.logger.warn("failed to send metrics", e);
            }
        }
    }

    private void addMeter(Meter meter, AggregateMetricSender.Session session, long timestamp) {
        for (Measurement measurement : meter.measure()) {
            String statSuffix = NamingConvention.camelCase.tagKey(measurement.getStatistic().toString());
            switch (measurement.getStatistic()) {
                case TOTAL: 
                case TOTAL_TIME: 
                case COUNT: 
                case DURATION: {
                    this.addDatapoint(meter, SignalFxProtocolBuffers.MetricType.COUNTER, statSuffix, session, measurement.getValue(), timestamp);
                    break;
                }
                case MAX: 
                case VALUE: 
                case UNKNOWN: 
                case ACTIVE_TASKS: {
                    this.addDatapoint(meter, SignalFxProtocolBuffers.MetricType.GAUGE, statSuffix, session, measurement.getValue(), timestamp);
                }
            }
        }
    }

    private void addDatapoint(Meter meter, SignalFxProtocolBuffers.MetricType metricType, @Nullable String statSuffix, AggregateMetricSender.Session session, Number value, long timestamp) {
        SignalFxProtocolBuffers.Datum.Builder datumBuilder = SignalFxProtocolBuffers.Datum.newBuilder();
        SignalFxProtocolBuffers.Datum datum = (value instanceof Double ? datumBuilder.setDoubleValue(((Double)value).doubleValue()) : datumBuilder.setIntValue(((Long)value).longValue())).build();
        String metricName = this.config().namingConvention().name(statSuffix == null ? meter.getId().getName() : meter.getId().getName() + "." + statSuffix, meter.getId().getType(), meter.getId().getBaseUnit());
        SignalFxProtocolBuffers.DataPoint.Builder dataPointBuilder = SignalFxProtocolBuffers.DataPoint.newBuilder().setMetric(metricName).setMetricType(metricType).setValue(datum).setTimestamp(timestamp);
        for (Tag tag : this.getConventionTags(meter.getId())) {
            dataPointBuilder.addDimensions(SignalFxProtocolBuffers.Dimension.newBuilder().setKey(tag.getKey()).setValue(tag.getValue()).build());
        }
        session.setDatapoint(dataPointBuilder.build());
    }

    private void addLongTaskTimer(LongTaskTimer longTaskTimer, AggregateMetricSender.Session session, long timestamp) {
        this.addDatapoint((Meter)longTaskTimer, SignalFxProtocolBuffers.MetricType.GAUGE, "activeTasks", session, longTaskTimer.activeTasks(), timestamp);
        this.addDatapoint((Meter)longTaskTimer, SignalFxProtocolBuffers.MetricType.COUNTER, "duration", session, longTaskTimer.duration(this.getBaseTimeUnit()), timestamp);
    }

    private void addTimeGauge(TimeGauge timeGauge, AggregateMetricSender.Session session, long timestamp) {
        this.addDatapoint((Meter)timeGauge, SignalFxProtocolBuffers.MetricType.GAUGE, null, session, timeGauge.value(this.getBaseTimeUnit()), timestamp);
    }

    private void addGauge(Gauge gauge, AggregateMetricSender.Session session, long timestamp) {
        this.addDatapoint((Meter)gauge, SignalFxProtocolBuffers.MetricType.GAUGE, null, session, gauge.value(), timestamp);
    }

    private void addCounter(Counter counter, AggregateMetricSender.Session session, long timestamp) {
        this.addDatapoint((Meter)counter, SignalFxProtocolBuffers.MetricType.COUNTER, null, session, counter.count(), timestamp);
    }

    private void addFunctionCounter(FunctionCounter counter, AggregateMetricSender.Session session, long timestamp) {
        this.addDatapoint((Meter)counter, SignalFxProtocolBuffers.MetricType.COUNTER, null, session, counter.count(), timestamp);
    }

    private void addTimer(Timer timer, AggregateMetricSender.Session session, long timestamp) {
        HistogramSnapshot snapshot = timer.takeSnapshot(false);
        this.addDatapoint((Meter)timer, SignalFxProtocolBuffers.MetricType.COUNTER, "count", session, snapshot.count(), timestamp);
        this.addDatapoint((Meter)timer, SignalFxProtocolBuffers.MetricType.COUNTER, "totalTime", session, snapshot.total(this.getBaseTimeUnit()), timestamp);
        this.addDatapoint((Meter)timer, SignalFxProtocolBuffers.MetricType.GAUGE, "avg", session, snapshot.mean(this.getBaseTimeUnit()), timestamp);
        this.addDatapoint((Meter)timer, SignalFxProtocolBuffers.MetricType.GAUGE, "max", session, snapshot.max(this.getBaseTimeUnit()), timestamp);
        for (ValueAtPercentile v : snapshot.percentileValues()) {
            String suffix = DoubleFormat.toString((double)(v.percentile() * 100.0)) + "percentile";
            this.addDatapoint((Meter)timer, SignalFxProtocolBuffers.MetricType.GAUGE, suffix, session, v.value(this.getBaseTimeUnit()), timestamp);
        }
    }

    private void addFunctionTimer(FunctionTimer timer, AggregateMetricSender.Session session, long timestamp) {
        this.addDatapoint((Meter)timer, SignalFxProtocolBuffers.MetricType.COUNTER, "count", session, timer.count(), timestamp);
        this.addDatapoint((Meter)timer, SignalFxProtocolBuffers.MetricType.COUNTER, "totalTime", session, timer.totalTime(this.getBaseTimeUnit()), timestamp);
        this.addDatapoint((Meter)timer, SignalFxProtocolBuffers.MetricType.GAUGE, "avg", session, timer.mean(this.getBaseTimeUnit()), timestamp);
    }

    private void addDistributionSummary(DistributionSummary summary, AggregateMetricSender.Session session, long timestamp) {
        HistogramSnapshot snapshot = summary.takeSnapshot(false);
        this.addDatapoint((Meter)summary, SignalFxProtocolBuffers.MetricType.COUNTER, "count", session, snapshot.count(), timestamp);
        this.addDatapoint((Meter)summary, SignalFxProtocolBuffers.MetricType.COUNTER, "totalTime", session, snapshot.total(), timestamp);
        this.addDatapoint((Meter)summary, SignalFxProtocolBuffers.MetricType.GAUGE, "avg", session, snapshot.mean(), timestamp);
        this.addDatapoint((Meter)summary, SignalFxProtocolBuffers.MetricType.GAUGE, "max", session, snapshot.max(), timestamp);
        for (ValueAtPercentile v : snapshot.percentileValues()) {
            String suffix = DoubleFormat.toString((double)(v.percentile() * 100.0)) + "percentile";
            this.addDatapoint((Meter)summary, SignalFxProtocolBuffers.MetricType.GAUGE, suffix, session, v.value(), timestamp);
        }
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }
}

