/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus;

import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.step.StepDouble;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class PrometheusTimer
extends AbstractTimer
implements Timer {
    private final LongAdder count = new LongAdder();
    private final LongAdder totalTime = new LongAdder();
    private final StepDouble max;

    PrometheusTimer(Meter.Id id, Clock clock, HistogramConfig histogramConfig, long maxStepMillis) {
        super(id, clock, histogramConfig);
        this.max = new StepDouble(clock, maxStepMillis);
    }

    protected void recordNonNegative(long amount, TimeUnit unit) {
        this.count.increment();
        long nanoAmount = TimeUnit.NANOSECONDS.convert(amount, unit);
        this.totalTime.add(nanoAmount);
        this.max.getCurrent().add(Math.max((double)nanoAmount - this.max.getCurrent().doubleValue(), 0.0));
    }

    public long count() {
        return this.count.longValue();
    }

    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit((double)this.totalTime.doubleValue(), (TimeUnit)unit);
    }

    public double max(TimeUnit unit) {
        return TimeUtils.nanosToUnit((double)this.max.poll(), (TimeUnit)unit);
    }
}

