/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionCounter;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionTimer;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.internal.DefaultGauge;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.micrometer.core.instrument.internal.DefaultMeter;
import io.micrometer.core.lang.Nullable;
import io.micrometer.prometheus.MicrometerCollector;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusCounter;
import io.micrometer.prometheus.PrometheusDistributionSummary;
import io.micrometer.prometheus.PrometheusNamingConvention;
import io.micrometer.prometheus.PrometheusTimer;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class PrometheusMeterRegistry
extends MeterRegistry {
    private final CollectorRegistry registry;
    private final ConcurrentMap<String, MicrometerCollector> collectorMap = new ConcurrentHashMap<String, MicrometerCollector>();
    private final PrometheusConfig prometheusConfig;

    public PrometheusMeterRegistry(PrometheusConfig config) {
        this(config, new CollectorRegistry(), Clock.SYSTEM);
    }

    public PrometheusMeterRegistry(PrometheusConfig config, CollectorRegistry registry, Clock clock) {
        super(clock);
        this.registry = registry;
        this.config().namingConvention((NamingConvention)new PrometheusNamingConvention());
        this.prometheusConfig = config;
    }

    public String scrape() {
        StringWriter writer = new StringWriter();
        try {
            TextFormat.write004((Writer)writer, (Enumeration)this.registry.metricFamilySamples());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ((Object)writer).toString();
    }

    public Counter newCounter(Meter.Id id) {
        MicrometerCollector collector = this.collectorByName(id);
        PrometheusCounter counter = new PrometheusCounter(id);
        List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
        collector.add((conventionName, tagKeys) -> Stream.of(new MicrometerCollector.Family(Collector.Type.COUNTER, conventionName, Stream.of(new Collector.MetricFamilySamples.Sample(conventionName, tagKeys, tagValues, counter.count())))));
        return counter;
    }

    public DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        MicrometerCollector collector = this.collectorByName(id);
        PrometheusDistributionSummary summary = new PrometheusDistributionSummary(id, this.clock, distributionStatisticConfig, scale);
        List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
        collector.add((conventionName, tagKeys) -> {
            Stream.Builder<Collector.MetricFamilySamples.Sample> samples = Stream.builder();
            ValueAtPercentile[] percentileValues = summary.takeSnapshot().percentileValues();
            CountAtBucket[] histogramCounts = summary.histogramCounts();
            double count = summary.count();
            if (percentileValues.length > 0) {
                LinkedList<String> quantileKeys = new LinkedList<String>(tagKeys);
                quantileKeys.add("quantile");
                for (ValueAtPercentile v : percentileValues) {
                    LinkedList<String> quantileValues = new LinkedList<String>(tagValues);
                    quantileValues.add(Collector.doubleToGoString((double)v.percentile()));
                    samples.add(new Collector.MetricFamilySamples.Sample(conventionName, quantileKeys, quantileValues, v.value()));
                }
            }
            Collector.Type type = Collector.Type.SUMMARY;
            if (histogramCounts.length > 0) {
                type = Collector.Type.HISTOGRAM;
                LinkedList<String> histogramKeys = new LinkedList<String>(tagKeys);
                histogramKeys.add("le");
                for (CountAtBucket c : histogramCounts) {
                    LinkedList<String> histogramValues = new LinkedList<String>(tagValues);
                    histogramValues.add(Collector.doubleToGoString((double)c.bucket()));
                    samples.add(new Collector.MetricFamilySamples.Sample(conventionName + "_bucket", histogramKeys, histogramValues, c.count()));
                }
                LinkedList<String> histogramValues = new LinkedList<String>(tagValues);
                histogramValues.add("+Inf");
                samples.add(new Collector.MetricFamilySamples.Sample(conventionName + "_bucket", histogramKeys, histogramValues, count));
            }
            samples.add(new Collector.MetricFamilySamples.Sample(conventionName + "_count", tagKeys, tagValues, count));
            samples.add(new Collector.MetricFamilySamples.Sample(conventionName + "_sum", tagKeys, tagValues, summary.totalAmount()));
            return Stream.of(new MicrometerCollector.Family(type, conventionName, samples.build()), new MicrometerCollector.Family(Collector.Type.GAUGE, conventionName + "_max", Stream.of(new Collector.MetricFamilySamples.Sample(conventionName + "_max", tagKeys, tagValues, summary.max()))));
        });
        return summary;
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        MicrometerCollector collector = this.collectorByName(id);
        PrometheusTimer timer = new PrometheusTimer(id, this.clock, distributionStatisticConfig, pauseDetector);
        List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
        collector.add((conventionName, tagKeys) -> {
            Collector.Type type;
            Stream.Builder<Collector.MetricFamilySamples.Sample> samples = Stream.builder();
            ValueAtPercentile[] percentileValues = timer.takeSnapshot().percentileValues();
            CountAtBucket[] histogramCounts = timer.histogramCounts();
            double count = timer.count();
            if (percentileValues.length > 0) {
                LinkedList<String> quantileKeys = new LinkedList<String>(tagKeys);
                quantileKeys.add("quantile");
                for (ValueAtPercentile v : percentileValues) {
                    LinkedList<String> quantileValues = new LinkedList<String>(tagValues);
                    quantileValues.add(Collector.doubleToGoString((double)v.percentile()));
                    samples.add(new Collector.MetricFamilySamples.Sample(conventionName, quantileKeys, quantileValues, v.value(TimeUnit.SECONDS)));
                }
            }
            Collector.Type type2 = type = distributionStatisticConfig.isPublishingHistogram() ? Collector.Type.HISTOGRAM : Collector.Type.SUMMARY;
            if (histogramCounts.length > 0) {
                type = Collector.Type.HISTOGRAM;
                LinkedList<String> histogramKeys = new LinkedList<String>(tagKeys);
                histogramKeys.add("le");
                for (CountAtBucket c : histogramCounts) {
                    LinkedList<String> histogramValues = new LinkedList<String>(tagValues);
                    histogramValues.add(Collector.doubleToGoString((double)c.bucket(TimeUnit.SECONDS)));
                    samples.add(new Collector.MetricFamilySamples.Sample(conventionName + "_bucket", histogramKeys, histogramValues, c.count()));
                }
                LinkedList<String> histogramValues = new LinkedList<String>(tagValues);
                histogramValues.add("+Inf");
                samples.add(new Collector.MetricFamilySamples.Sample(conventionName + "_bucket", histogramKeys, histogramValues, count));
            }
            samples.add(new Collector.MetricFamilySamples.Sample(conventionName + "_count", tagKeys, tagValues, count));
            samples.add(new Collector.MetricFamilySamples.Sample(conventionName + "_sum", tagKeys, tagValues, timer.totalTime(TimeUnit.SECONDS)));
            return Stream.of(new MicrometerCollector.Family(type, conventionName, samples.build()), new MicrometerCollector.Family(Collector.Type.GAUGE, conventionName + "_max", Stream.of(new Collector.MetricFamilySamples.Sample(conventionName + "_max", tagKeys, tagValues, timer.max(this.getBaseTimeUnit())))));
        });
        return timer;
    }

    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        MicrometerCollector collector = this.collectorByName(id);
        DefaultGauge gauge = new DefaultGauge(id, obj, valueFunction);
        List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
        collector.add((arg_0, arg_1) -> PrometheusMeterRegistry.lambda$newGauge$3(tagValues, (Gauge)gauge, arg_0, arg_1));
        return gauge;
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id) {
        MicrometerCollector collector = this.collectorByName(id);
        DefaultLongTaskTimer ltt = new DefaultLongTaskTimer(id, this.clock);
        List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
        collector.add((arg_0, arg_1) -> PrometheusMeterRegistry.lambda$newLongTaskTimer$4(tagValues, (LongTaskTimer)ltt, arg_0, arg_1));
        return ltt;
    }

    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits) {
        MicrometerCollector collector = this.collectorByName(id);
        CumulativeFunctionTimer ft = new CumulativeFunctionTimer(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnits, this.getBaseTimeUnit());
        List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
        collector.add((arg_0, arg_1) -> PrometheusMeterRegistry.lambda$newFunctionTimer$5(tagValues, (FunctionTimer)ft, arg_0, arg_1));
        return ft;
    }

    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        MicrometerCollector collector = this.collectorByName(id);
        CumulativeFunctionCounter fc = new CumulativeFunctionCounter(id, obj, countFunction);
        List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
        collector.add((arg_0, arg_1) -> PrometheusMeterRegistry.lambda$newFunctionCounter$6(tagValues, (FunctionCounter)fc, arg_0, arg_1));
        return fc;
    }

    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        Collector.Type promType = Collector.Type.UNTYPED;
        switch (type) {
            case COUNTER: {
                promType = Collector.Type.COUNTER;
                break;
            }
            case GAUGE: {
                promType = Collector.Type.GAUGE;
                break;
            }
            case DISTRIBUTION_SUMMARY: 
            case TIMER: {
                promType = Collector.Type.SUMMARY;
            }
        }
        MicrometerCollector collector = this.collectorByName(id);
        List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
        Collector.Type finalPromType = promType;
        collector.add((conventionName, tagKeys) -> {
            LinkedList<String> statKeys = new LinkedList<String>(tagKeys);
            statKeys.add("statistic");
            return Stream.of(new MicrometerCollector.Family(finalPromType, conventionName, StreamSupport.stream(measurements.spliterator(), false).map(m -> {
                LinkedList<String> statValues = new LinkedList<String>(tagValues);
                statValues.add(m.getStatistic().toString());
                String name = conventionName;
                switch (m.getStatistic()) {
                    case TOTAL: 
                    case TOTAL_TIME: {
                        name = name + "_sum";
                        break;
                    }
                    case MAX: {
                        name = name + "_max";
                        break;
                    }
                    case ACTIVE_TASKS: {
                        name = name + "_active_count";
                        break;
                    }
                    case DURATION: {
                        name = name + "_duration_sum";
                    }
                }
                return new Collector.MetricFamilySamples.Sample(name, statKeys, statValues, m.getValue());
            })));
        });
        return new DefaultMeter(id, type, measurements);
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    public CollectorRegistry getPrometheusRegistry() {
        return this.registry;
    }

    private static List<String> tagValues(Meter.Id id) {
        return id.getTags().stream().map(Tag::getValue).collect(Collectors.toList());
    }

    private MicrometerCollector collectorByName(Meter.Id id) {
        return this.collectorMap.compute(this.getConventionName(id), (name, existingCollector) -> {
            if (existingCollector == null) {
                return (MicrometerCollector)new MicrometerCollector(id, this.config().namingConvention(), this.prometheusConfig).register(this.registry);
            }
            List tagKeys = this.getConventionTags(id).stream().map(Tag::getKey).collect(Collectors.toList());
            if (existingCollector.getTagKeys().equals(tagKeys)) {
                return existingCollector;
            }
            throw new IllegalArgumentException("Prometheus requires that all meters with the same name have the same set of tag keys. There is already an existing meter containing tag keys [" + existingCollector.getTagKeys().stream().collect(Collectors.joining(", ")) + "]. The meter you are attempting to register has keys [" + tagKeys.stream().collect(Collectors.joining(", ")) + "].");
        });
    }

    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.prometheusConfig.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }

    private static /* synthetic */ Stream lambda$newFunctionCounter$6(List tagValues, FunctionCounter fc, String conventionName, List tagKeys) {
        return Stream.of(new MicrometerCollector.Family(Collector.Type.COUNTER, conventionName, Stream.of(new Collector.MetricFamilySamples.Sample(conventionName, tagKeys, tagValues, fc.count()))));
    }

    private static /* synthetic */ Stream lambda$newFunctionTimer$5(List tagValues, FunctionTimer ft, String conventionName, List tagKeys) {
        return Stream.of(new MicrometerCollector.Family(Collector.Type.SUMMARY, conventionName, Stream.of(new Collector.MetricFamilySamples.Sample(conventionName + "_count", tagKeys, tagValues, ft.count()), new Collector.MetricFamilySamples.Sample(conventionName + "_sum", tagKeys, tagValues, ft.totalTime(TimeUnit.SECONDS)))));
    }

    private static /* synthetic */ Stream lambda$newLongTaskTimer$4(List tagValues, LongTaskTimer ltt, String conventionName, List tagKeys) {
        return Stream.of(new MicrometerCollector.Family(Collector.Type.UNTYPED, conventionName, Stream.of(new Collector.MetricFamilySamples.Sample(conventionName + "_active_count", tagKeys, tagValues, (double)ltt.activeTasks()), new Collector.MetricFamilySamples.Sample(conventionName + "_duration_sum", tagKeys, tagValues, ltt.duration(TimeUnit.SECONDS)))));
    }

    private static /* synthetic */ Stream lambda$newGauge$3(List tagValues, Gauge gauge, String conventionName, List tagKeys) {
        return Stream.of(new MicrometerCollector.Family(Collector.Type.GAUGE, conventionName, Stream.of(new Collector.MetricFamilySamples.Sample(conventionName, tagKeys, tagValues, gauge.value()))));
    }
}

