/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.CountAtValue;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.HistogramSnapshot;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.ValueAtPercentile;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionCounter;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionTimer;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.histogram.pause.PauseDetector;
import io.micrometer.core.instrument.internal.DefaultGauge;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.micrometer.core.instrument.internal.DefaultMeter;
import io.micrometer.prometheus.MicrometerCollector;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusCounter;
import io.micrometer.prometheus.PrometheusDistributionSummary;
import io.micrometer.prometheus.PrometheusNamingConvention;
import io.micrometer.prometheus.PrometheusTimer;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class PrometheusMeterRegistry
extends MeterRegistry {
    private final CollectorRegistry registry;
    private final ConcurrentMap<String, MicrometerCollector> collectorMap = new ConcurrentHashMap<String, MicrometerCollector>();
    private final PrometheusConfig prometheusConfig;

    public PrometheusMeterRegistry(PrometheusConfig config) {
        this(config, new CollectorRegistry(), Clock.SYSTEM);
    }

    public PrometheusMeterRegistry(PrometheusConfig config, CollectorRegistry registry, Clock clock) {
        super(clock);
        this.registry = registry;
        this.config().namingConvention((NamingConvention)new PrometheusNamingConvention());
        this.prometheusConfig = config;
    }

    public String scrape() {
        StringWriter writer = new StringWriter();
        try {
            TextFormat.write004((Writer)writer, (Enumeration)this.registry.metricFamilySamples());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ((Object)writer).toString();
    }

    public Counter newCounter(Meter.Id id) {
        MicrometerCollector collector = this.collectorByName(id, Collector.Type.COUNTER);
        PrometheusCounter counter = new PrometheusCounter(id);
        List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
        collector.add((conventionName, tagKeys) -> Stream.of(new Collector.MetricFamilySamples.Sample(conventionName, tagKeys, tagValues, counter.count())));
        return counter;
    }

    public DistributionSummary newDistributionSummary(Meter.Id id, HistogramConfig histogramConfig) {
        MicrometerCollector collector = this.collectorByName(id, Collector.Type.SUMMARY);
        PrometheusDistributionSummary summary = new PrometheusDistributionSummary(id, this.clock, histogramConfig);
        List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
        collector.add((conventionName, tagKeys) -> {
            Stream.Builder<Collector.MetricFamilySamples.Sample> samples = Stream.builder();
            HistogramSnapshot snapshot = summary.takeSnapshot(false);
            ValueAtPercentile[] percentileValues = snapshot.percentileValues();
            CountAtValue[] histogramCounts = summary.percentileBuckets();
            if (percentileValues.length > 0) {
                LinkedList<String> quantileKeys = new LinkedList<String>(tagKeys);
                quantileKeys.add("quantile");
                for (ValueAtPercentile valueAtPercentile : percentileValues) {
                    LinkedList<String> quantileValues = new LinkedList<String>(tagValues);
                    quantileValues.add(Collector.doubleToGoString((double)valueAtPercentile.percentile()));
                    samples.add(new Collector.MetricFamilySamples.Sample(conventionName, quantileKeys, quantileValues, valueAtPercentile.value()));
                }
            }
            if (histogramCounts.length > 0) {
                collector.setType(Collector.Type.HISTOGRAM);
                LinkedList<String> histogramKeys = new LinkedList<String>(tagKeys);
                histogramKeys.add("le");
                for (ValueAtPercentile valueAtPercentile : histogramCounts) {
                    LinkedList<String> histogramValues = new LinkedList<String>(tagValues);
                    long bucket = valueAtPercentile.value();
                    if (bucket == Long.MAX_VALUE) {
                        histogramValues.add("+Inf");
                    } else {
                        histogramValues.add(Collector.doubleToGoString((double)bucket));
                    }
                    samples.add(new Collector.MetricFamilySamples.Sample(conventionName + "_bucket", histogramKeys, histogramValues, valueAtPercentile.count()));
                }
            }
            samples.add(new Collector.MetricFamilySamples.Sample(conventionName + "_count", tagKeys, tagValues, (double)snapshot.count()));
            samples.add(new Collector.MetricFamilySamples.Sample(conventionName + "_sum", tagKeys, tagValues, snapshot.total()));
            samples.add(new Collector.MetricFamilySamples.Sample(conventionName + "_max", tagKeys, tagValues, snapshot.max()));
            return samples.build();
        });
        return summary;
    }

    protected Timer newTimer(Meter.Id id, HistogramConfig histogramConfig, PauseDetector pauseDetector) {
        MicrometerCollector collector = this.collectorByName(id, histogramConfig.isPublishingHistogram() ? Collector.Type.HISTOGRAM : Collector.Type.SUMMARY);
        PrometheusTimer timer = new PrometheusTimer(id, this.clock, histogramConfig, pauseDetector);
        List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
        collector.add((conventionName, tagKeys) -> {
            Stream.Builder<Collector.MetricFamilySamples.Sample> samples = Stream.builder();
            HistogramSnapshot snapshot = timer.takeSnapshot(false);
            ValueAtPercentile[] percentileValues = snapshot.percentileValues();
            CountAtValue[] histogramCounts = timer.percentileBuckets();
            if (percentileValues.length > 0) {
                LinkedList<String> quantileKeys = new LinkedList<String>(tagKeys);
                quantileKeys.add("quantile");
                for (ValueAtPercentile valueAtPercentile : percentileValues) {
                    LinkedList<String> quantileValues = new LinkedList<String>(tagValues);
                    quantileValues.add(Collector.doubleToGoString((double)valueAtPercentile.percentile()));
                    samples.add(new Collector.MetricFamilySamples.Sample(conventionName, quantileKeys, quantileValues, valueAtPercentile.value(TimeUnit.SECONDS)));
                }
            }
            if (histogramCounts.length > 0) {
                collector.setType(Collector.Type.HISTOGRAM);
                LinkedList<String> histogramKeys = new LinkedList<String>(tagKeys);
                histogramKeys.add("le");
                for (ValueAtPercentile valueAtPercentile : histogramCounts) {
                    LinkedList<String> histogramValues = new LinkedList<String>(tagValues);
                    histogramValues.add(Collector.doubleToGoString((double)valueAtPercentile.value(TimeUnit.SECONDS)));
                    samples.add(new Collector.MetricFamilySamples.Sample(conventionName + "_bucket", histogramKeys, histogramValues, valueAtPercentile.count()));
                }
                LinkedList<String> histogramValues = new LinkedList<String>(tagValues);
                histogramValues.add("+Inf");
                samples.add(new Collector.MetricFamilySamples.Sample(conventionName + "_bucket", histogramKeys, histogramValues, (double)snapshot.count()));
            }
            samples.add(new Collector.MetricFamilySamples.Sample(conventionName + "_count", tagKeys, tagValues, (double)snapshot.count()));
            samples.add(new Collector.MetricFamilySamples.Sample(conventionName + "_sum", tagKeys, tagValues, snapshot.total(TimeUnit.SECONDS)));
            samples.add(new Collector.MetricFamilySamples.Sample(conventionName + "_max", tagKeys, tagValues, snapshot.max(TimeUnit.SECONDS)));
            return samples.build();
        });
        return timer;
    }

    protected <T> Gauge newGauge(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        MicrometerCollector collector = this.collectorByName(id, Collector.Type.GAUGE);
        DefaultGauge gauge = new DefaultGauge(id, obj, f);
        List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
        collector.add((arg_0, arg_1) -> PrometheusMeterRegistry.lambda$newGauge$3(tagValues, (Gauge)gauge, arg_0, arg_1));
        return gauge;
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id) {
        MicrometerCollector collector = this.collectorByName(id, Collector.Type.UNTYPED);
        DefaultLongTaskTimer ltt = new DefaultLongTaskTimer(id, this.clock);
        List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
        collector.add((arg_0, arg_1) -> PrometheusMeterRegistry.lambda$newLongTaskTimer$4(tagValues, (LongTaskTimer)ltt, arg_0, arg_1));
        return ltt;
    }

    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits) {
        MicrometerCollector collector = this.collectorByName(id, Collector.Type.SUMMARY);
        CumulativeFunctionTimer ft = new CumulativeFunctionTimer(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnits, this.getBaseTimeUnit());
        List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
        collector.add((arg_0, arg_1) -> PrometheusMeterRegistry.lambda$newFunctionTimer$5(tagValues, (FunctionTimer)ft, arg_0, arg_1));
        return ft;
    }

    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        MicrometerCollector collector = this.collectorByName(id, Collector.Type.COUNTER);
        CumulativeFunctionCounter fc = new CumulativeFunctionCounter(id, obj, f);
        List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
        collector.add((arg_0, arg_1) -> PrometheusMeterRegistry.lambda$newFunctionCounter$6(tagValues, (FunctionCounter)fc, arg_0, arg_1));
        return fc;
    }

    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        Collector.Type promType = Collector.Type.UNTYPED;
        switch (type) {
            case Counter: {
                promType = Collector.Type.COUNTER;
                break;
            }
            case Gauge: {
                promType = Collector.Type.GAUGE;
                break;
            }
            case DistributionSummary: 
            case Timer: {
                promType = Collector.Type.SUMMARY;
            }
        }
        MicrometerCollector collector = this.collectorByName(id, promType);
        List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
        collector.add((conventionName, tagKeys) -> {
            LinkedList<String> statKeys = new LinkedList<String>(tagKeys);
            statKeys.add("statistic");
            return StreamSupport.stream(measurements.spliterator(), false).map(m -> {
                LinkedList<String> statValues = new LinkedList<String>(tagValues);
                statValues.add(m.getStatistic().toString());
                String name = conventionName;
                switch (m.getStatistic()) {
                    case Total: 
                    case TotalTime: {
                        name = name + "_sum";
                        break;
                    }
                    case Max: {
                        name = name + "_max";
                        break;
                    }
                    case ActiveTasks: {
                        name = name + "_active_count";
                        break;
                    }
                    case Duration: {
                        name = name + "_duration_sum";
                    }
                }
                return new Collector.MetricFamilySamples.Sample(name, tagKeys, tagValues, m.getValue());
            });
        });
        return new DefaultMeter(id, type, measurements);
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    public CollectorRegistry getPrometheusRegistry() {
        return this.registry;
    }

    private static List<String> tagValues(Meter.Id id) {
        return StreamSupport.stream(id.getTags().spliterator(), false).map(Tag::getValue).collect(Collectors.toList());
    }

    private MicrometerCollector collectorByName(Meter.Id id, Collector.Type type) {
        return this.collectorMap.compute(this.getConventionName(id), (name, existingCollector) -> {
            if (existingCollector == null) {
                return (MicrometerCollector)new MicrometerCollector(id, type, this.config().namingConvention(), this.prometheusConfig).register(this.registry);
            }
            List tagKeys = this.getConventionTags(id).stream().map(Tag::getKey).collect(Collectors.toList());
            if (existingCollector.getTagKeys().equals(tagKeys)) {
                return existingCollector;
            }
            throw new IllegalArgumentException("Prometheus requires that all meters with the same name have the same set of tag keys. There is already an existing meter containing tag keys [" + existingCollector.getTagKeys().stream().collect(Collectors.joining(", ")) + "]. The meter you are attempting to register has keys [" + tagKeys.stream().collect(Collectors.joining(", ")) + "].");
        });
    }

    protected HistogramConfig defaultHistogramConfig() {
        return HistogramConfig.builder().histogramExpiry(this.prometheusConfig.step()).build().merge(HistogramConfig.DEFAULT);
    }

    private static /* synthetic */ Stream lambda$newFunctionCounter$6(List tagValues, FunctionCounter fc, String conventionName, List tagKeys) {
        return Stream.of(new Collector.MetricFamilySamples.Sample(conventionName, tagKeys, tagValues, fc.count()));
    }

    private static /* synthetic */ Stream lambda$newFunctionTimer$5(List tagValues, FunctionTimer ft, String conventionName, List tagKeys) {
        return Stream.of(new Collector.MetricFamilySamples.Sample(conventionName + "_count", tagKeys, tagValues, ft.count()), new Collector.MetricFamilySamples.Sample(conventionName + "_sum", tagKeys, tagValues, ft.totalTime(TimeUnit.SECONDS)));
    }

    private static /* synthetic */ Stream lambda$newLongTaskTimer$4(List tagValues, LongTaskTimer ltt, String conventionName, List tagKeys) {
        return Stream.of(new Collector.MetricFamilySamples.Sample(conventionName + "_active_count", tagKeys, tagValues, (double)ltt.activeTasks()), new Collector.MetricFamilySamples.Sample(conventionName + "_duration_sum", tagKeys, tagValues, ltt.duration(TimeUnit.SECONDS)));
    }

    private static /* synthetic */ Stream lambda$newGauge$3(List tagValues, Gauge gauge, String conventionName, List tagKeys) {
        return Stream.of(new Collector.MetricFamilySamples.Sample(conventionName, tagKeys, tagValues, gauge.value()));
    }
}

