/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus;

import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.step.StepDouble;
import io.micrometer.core.instrument.util.MeterEquivalence;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

public class PrometheusDistributionSummary
extends AbstractDistributionSummary {
    private LongAdder count = new LongAdder();
    private DoubleAdder amount = new DoubleAdder();
    private StepDouble max;

    PrometheusDistributionSummary(Meter.Id id, Clock clock, HistogramConfig histogramConfig, long maxStepMillis) {
        super(id, clock, histogramConfig);
        this.max = new StepDouble(clock, maxStepMillis);
    }

    protected void recordNonNegative(double amount) {
        this.count.increment();
        this.amount.add(amount);
        this.max.getCurrent().add(Math.max(amount - this.max.getCurrent().doubleValue(), 0.0));
    }

    public long count() {
        return this.count.longValue();
    }

    public double totalAmount() {
        return this.amount.doubleValue();
    }

    public double max() {
        return this.max.poll();
    }

    public boolean equals(Object o) {
        return MeterEquivalence.equals((Meter)this, (Object)o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode((Meter)this);
    }
}

