/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.prometheus.PrometheusConfig;
import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MicrometerCollector
extends Collector {
    private final Meter.Id id;
    private final List<Child> children = new ArrayList<Child>();
    private Collector.Type type;
    private final String conventionName;
    private final List<String> tagKeys;
    private final PrometheusConfig config;

    public MicrometerCollector(Meter.Id id, Collector.Type type, NamingConvention convention, PrometheusConfig config) {
        this.id = id;
        this.type = type;
        this.conventionName = id.getConventionName(convention);
        this.tagKeys = id.getConventionTags(convention).stream().map(Tag::getKey).collect(Collectors.toList());
        this.config = config;
    }

    public void add(Child child) {
        this.children.add(child);
    }

    public void setType(Collector.Type type) {
        this.type = type;
    }

    public List<Collector.MetricFamilySamples> collect() {
        String help;
        String string = help = this.config.descriptions() ? this.id.getDescription() : " ";
        if (help == null) {
            help = " ";
        }
        return Collections.singletonList(new Collector.MetricFamilySamples(this.conventionName, this.type, help, this.children.stream().flatMap(child -> child.samples(this.conventionName, this.tagKeys)).collect(Collectors.toList())));
    }

    static interface Child {
        public Stream<Collector.MetricFamilySamples.Sample> samples(String var1, List<String> var2);
    }
}

