/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus.internal;

import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Tag;
import io.micrometer.prometheus.internal.CustomCollectorChild;
import io.micrometer.prometheus.internal.PrometheusCollectorId;
import io.prometheus.client.Collector;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CustomPrometheusFunctionTimer
extends Collector {
    private final PrometheusCollectorId id;
    private final String countName;
    private final String sumName;
    private final Collection<Child> children = new ConcurrentLinkedQueue<Child>();

    public CustomPrometheusFunctionTimer(PrometheusCollectorId id) {
        this.id = id;
        this.countName = id.getName() + "_count";
        this.sumName = id.getName() + "_sum";
    }

    public Child child(Iterable<Tag> tags, FunctionTimer timer) {
        Child child = new Child(tags, timer);
        this.children.add(child);
        return child;
    }

    public List<Collector.MetricFamilySamples> collect() {
        return Collections.singletonList(new Collector.MetricFamilySamples(this.id.getName(), Collector.Type.SUMMARY, this.id.getDescription(), this.children.stream().flatMap(Child::collect).collect(Collectors.toList())));
    }

    public class Child
    implements CustomCollectorChild {
        private final List<String> tagValues;
        private final FunctionTimer timer;

        Child(Iterable<Tag> tags, FunctionTimer timer) {
            this.tagValues = StreamSupport.stream(tags.spliterator(), false).map(Tag::getValue).collect(Collectors.toList());
            this.timer = timer;
        }

        @Override
        public Stream<Collector.MetricFamilySamples.Sample> collect() {
            Stream.Builder<Collector.MetricFamilySamples.Sample> samples = Stream.builder();
            samples.add(new Collector.MetricFamilySamples.Sample(CustomPrometheusFunctionTimer.this.countName, CustomPrometheusFunctionTimer.this.id.getTagKeys(), this.tagValues, (double)this.timer.count()));
            samples.add(new Collector.MetricFamilySamples.Sample(CustomPrometheusFunctionTimer.this.sumName, CustomPrometheusFunctionTimer.this.id.getTagKeys(), this.tagValues, this.timer.totalTime(TimeUnit.SECONDS)));
            return samples.build();
        }
    }
}

