/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus.internal;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.NamingConvention;
import io.micrometer.core.instrument.Tag;
import io.micrometer.prometheus.internal.CustomCollectorChild;
import io.prometheus.client.Collector;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CustomPrometheusCollector
extends Collector {
    private final String name;
    private final Collector.Type type;
    private final List<String> tagKeys;
    private final Collection<Child> children = new ConcurrentLinkedQueue<Child>();

    public CustomPrometheusCollector(Meter.Id id, NamingConvention convention, Collector.Type type) {
        this.type = type;
        this.name = id.getConventionName(convention);
        this.tagKeys = id.getConventionTags(convention).stream().map(Tag::getKey).collect(Collectors.toList());
    }

    public Child child(Iterable<Tag> tags, Iterable<Measurement> measurements) {
        Child child = new Child(StreamSupport.stream(tags.spliterator(), false).map(Tag::getValue).collect(Collectors.toList()), measurements);
        this.children.add(child);
        return child;
    }

    public List<Collector.MetricFamilySamples> collect() {
        return Collections.singletonList(new Collector.MetricFamilySamples(this.name, this.type, " ", this.children.stream().flatMap(Child::collect).collect(Collectors.toList())));
    }

    class Child
    implements CustomCollectorChild {
        private final List<String> tagValues;
        private final Iterable<Measurement> measurements;

        Child(List<String> tagValues, Iterable<Measurement> measurements) {
            this.tagValues = tagValues;
            this.measurements = measurements;
        }

        @Override
        public Stream<Collector.MetricFamilySamples.Sample> collect() {
            return StreamSupport.stream(this.measurements.spliterator(), false).map(m -> new Collector.MetricFamilySamples.Sample(CustomPrometheusCollector.this.name, CustomPrometheusCollector.this.tagKeys, this.tagValues, m.getValue()));
        }
    }
}

