/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus;

import io.micrometer.core.instrument.AbstractMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.NamingConvention;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.stats.hist.BucketFilter;
import io.micrometer.core.instrument.stats.hist.DoubleHistogram;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.hist.PercentileHistogram;
import io.micrometer.core.instrument.stats.hist.PercentileTimeHistogram;
import io.micrometer.core.instrument.stats.hist.TimeHistogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusCounter;
import io.micrometer.prometheus.PrometheusDistributionSummary;
import io.micrometer.prometheus.PrometheusGauge;
import io.micrometer.prometheus.PrometheusLongTaskTimer;
import io.micrometer.prometheus.PrometheusNamingConvention;
import io.micrometer.prometheus.PrometheusTimer;
import io.micrometer.prometheus.internal.CustomPrometheusCollector;
import io.micrometer.prometheus.internal.CustomPrometheusLongTaskTimer;
import io.micrometer.prometheus.internal.CustomPrometheusSummary;
import io.micrometer.prometheus.internal.PrometheusCollectorId;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.SimpleCollector;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;

public class PrometheusMeterRegistry
extends AbstractMeterRegistry {
    private final CollectorRegistry registry;
    private final ConcurrentMap<String, Collector> collectorMap = new ConcurrentHashMap<String, Collector>();
    private final boolean sendDescriptions;
    private final PrometheusConfig prometheusConfig;

    public PrometheusMeterRegistry(PrometheusConfig config) {
        this(config, new CollectorRegistry(), Clock.SYSTEM);
    }

    public PrometheusMeterRegistry(PrometheusConfig config, CollectorRegistry registry, Clock clock) {
        super(clock);
        this.registry = registry;
        this.config().namingConvention((NamingConvention)new PrometheusNamingConvention());
        this.sendDescriptions = config.descriptions();
        this.prometheusConfig = config;
    }

    public String scrape() {
        StringWriter writer = new StringWriter();
        try {
            TextFormat.write004((Writer)writer, (Enumeration)this.registry.metricFamilySamples());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ((Object)writer).toString();
    }

    public io.micrometer.core.instrument.Counter newCounter(Meter.Id id) {
        Counter counter = this.collectorByName(Counter.class, this.getConventionName(id), n -> (Counter)this.buildCollector(id, (SimpleCollector.Builder)Counter.build()));
        return new PrometheusCounter(id, (Counter.Child)counter.labels(this.getConventionTags(id).stream().map(Tag::getValue).collect(Collectors.toList()).toArray(new String[0])));
    }

    public DistributionSummary newDistributionSummary(Meter.Id id, Histogram.Builder<?> histogram, Quantiles quantiles) {
        CustomPrometheusSummary summary = this.collectorByName(CustomPrometheusSummary.class, this.getConventionName(id), n -> (CustomPrometheusSummary)new CustomPrometheusSummary(this.collectorId(id)).register(this.registry));
        return new PrometheusDistributionSummary(id, summary.child(this.getConventionTags(id), quantiles, this.buildHistogramIfNecessary(histogram)));
    }

    protected Timer newTimer(Meter.Id id, Histogram.Builder<?> histogram, Quantiles quantiles) {
        id.setBaseUnit("seconds");
        CustomPrometheusSummary summary = this.collectorByName(CustomPrometheusSummary.class, this.getConventionName(id), n -> (CustomPrometheusSummary)new CustomPrometheusSummary(this.collectorId(id)).register(this.registry));
        return new PrometheusTimer(id, summary.child(this.getConventionTags(id), quantiles, this.buildHistogramIfNecessary(histogram)), this.config().clock());
    }

    private <T> Histogram<T> buildHistogramIfNecessary(Histogram.Builder<T> builder) {
        if (builder == null) {
            return null;
        }
        Histogram hist = builder.create(Histogram.Summation.Cumulative);
        if (hist instanceof PercentileHistogram || hist instanceof PercentileTimeHistogram) {
            Histogram percentileHist = hist;
            double max = (double)this.prometheusConfig.timerPercentilesMax().toNanos() / 1.0E9;
            double min = (double)this.prometheusConfig.timerPercentilesMin().toNanos() / 1.0E9;
            BucketFilter clampMax = BucketFilter.clampMax((Comparable)Double.valueOf(max));
            percentileHist.filterBuckets(b -> (Double)b.getTag() == Double.POSITIVE_INFINITY || clampMax.shouldPublish(b));
            percentileHist.filterBuckets(BucketFilter.clampMin((Comparable)Double.valueOf(min)));
        }
        if (hist instanceof DoubleHistogram) {
            ((DoubleHistogram)hist).infinityBucket();
        }
        if (hist instanceof TimeHistogram) {
            TimeHistogram timeHist = (TimeHistogram)hist;
            timeHist.bucketTimeScale(TimeUnit.SECONDS);
            timeHist.infinityBucket();
        }
        return hist;
    }

    protected <T> Gauge newGauge(Meter.Id id, T obj, final ToDoubleFunction<T> f) {
        final WeakReference<T> ref = new WeakReference<T>(obj);
        io.prometheus.client.Gauge gauge = this.collectorByName(io.prometheus.client.Gauge.class, this.getConventionName(id), i -> (io.prometheus.client.Gauge)this.buildCollector(id, (SimpleCollector.Builder)io.prometheus.client.Gauge.build()));
        String[] labelValues = this.getConventionTags(id).stream().map(Tag::getValue).collect(Collectors.toList()).toArray(new String[0]);
        Gauge.Child child = new Gauge.Child(){

            public double get() {
                Object obj2 = ref.get();
                return obj2 == null ? Double.NaN : f.applyAsDouble(obj2);
            }
        };
        gauge.setChild((Object)child, labelValues);
        return new PrometheusGauge(id, child);
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id) {
        CustomPrometheusLongTaskTimer longTaskTimer = this.collectorByName(CustomPrometheusLongTaskTimer.class, this.getConventionName(id), n -> (CustomPrometheusLongTaskTimer)new CustomPrometheusLongTaskTimer(this.collectorId(id), this.config().clock()).register(this.registry));
        return new PrometheusLongTaskTimer(id, longTaskTimer.child(this.getConventionTags(id)));
    }

    protected void newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        CustomPrometheusCollector c = (CustomPrometheusCollector)this.collectorMap.computeIfAbsent(this.getConventionName(id), name2 -> {
            Collector.Type promType = Collector.Type.UNTYPED;
            switch (type) {
                case Counter: {
                    promType = Collector.Type.COUNTER;
                    break;
                }
                case Gauge: {
                    promType = Collector.Type.GAUGE;
                    break;
                }
                case DistributionSummary: 
                case Timer: {
                    promType = Collector.Type.SUMMARY;
                }
            }
            CustomPrometheusCollector collector = new CustomPrometheusCollector(id, this.config().namingConvention(), promType);
            this.registry.register((Collector)collector);
            return collector;
        });
        c.child(this.getConventionTags(id), measurements);
    }

    public CollectorRegistry getPrometheusRegistry() {
        return this.registry;
    }

    private <B extends SimpleCollector.Builder<B, C>, C extends SimpleCollector<D>, D> C buildCollector(Meter.Id id, SimpleCollector.Builder<B, C> builder) {
        return (C)builder.name(this.getConventionName(id)).help(!this.sendDescriptions || id.getDescription() == null ? " " : id.getDescription()).labelNames(this.getConventionTags(id).stream().map(Tag::getKey).collect(Collectors.toList()).toArray(new String[0])).register(this.registry);
    }

    private <C extends Collector> C collectorByName(Class<C> collectorType, String name, Function<String, C> ifAbsent) {
        Collector collector = this.collectorMap.computeIfAbsent(name, ifAbsent);
        if (!collectorType.isInstance(collector)) {
            throw new IllegalArgumentException("There is already a registered meter of a different type with the same name");
        }
        return (C)collector;
    }

    protected <T> Gauge newTimeGauge(Meter.Id id, T obj, TimeUnit fUnit, ToDoubleFunction<T> f) {
        id.setBaseUnit("seconds");
        return this.newGauge(id, obj, obj2 -> TimeUtils.convert((double)f.applyAsDouble(obj2), (TimeUnit)fUnit, (TimeUnit)TimeUnit.SECONDS));
    }

    private PrometheusCollectorId collectorId(Meter.Id id) {
        return new PrometheusCollectorId(this.getConventionName(id), this.getConventionTags(id).stream().map(Tag::getKey).collect(Collectors.toList()), id.getDescription());
    }
}

