/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.newrelic;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.newrelic.ClientProviderType;
import io.micrometer.newrelic.NewRelicClientProvider;
import io.micrometer.newrelic.NewRelicConfig;
import io.micrometer.newrelic.NewRelicInsightsAgentClientProvider;
import io.micrometer.newrelic.NewRelicInsightsApiClientProvider;
import io.micrometer.newrelic.NewRelicNamingConvention;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class NewRelicMeterRegistry
extends StepMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("new-relic-metrics-publisher");
    private final NewRelicConfig config;
    final NewRelicClientProvider clientProvider;

    public NewRelicMeterRegistry(NewRelicConfig config, Clock clock) {
        this(config, null, clock);
    }

    public NewRelicMeterRegistry(NewRelicConfig config, NewRelicClientProvider clientProvider, Clock clock) {
        this(config, clientProvider, new NewRelicNamingConvention(), clock, DEFAULT_THREAD_FACTORY);
    }

    NewRelicMeterRegistry(NewRelicConfig config, NewRelicClientProvider clientProvider, NamingConvention namingConvention, Clock clock, ThreadFactory threadFactory) {
        super((StepRegistryConfig)config, clock);
        if (clientProvider == null) {
            clientProvider = config.clientProviderType() == ClientProviderType.INSIGHTS_AGENT ? new NewRelicInsightsAgentClientProvider(config) : new NewRelicInsightsApiClientProvider(config);
        }
        this.config = config;
        this.clientProvider = clientProvider;
        this.config().namingConvention(namingConvention);
        this.start(threadFactory);
    }

    public static Builder builder(NewRelicConfig config) {
        return new Builder(config);
    }

    protected void publish() {
        this.clientProvider.publish(this);
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    static /* synthetic */ ThreadFactory access$000() {
        return DEFAULT_THREAD_FACTORY;
    }

    public static class Builder {
        private final NewRelicConfig config;
        private NewRelicClientProvider clientProvider;
        private NamingConvention convention = new NewRelicNamingConvention();
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = NewRelicMeterRegistry.access$000();

        Builder(NewRelicConfig config) {
            this.config = config;
        }

        public Builder clientProvider(NewRelicClientProvider clientProvider) {
            this.clientProvider = clientProvider;
            return this;
        }

        public Builder namingConvention(NamingConvention convention) {
            this.convention = convention;
            return this;
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public NewRelicMeterRegistry build() {
            return new NewRelicMeterRegistry(this.config, this.clientProvider, this.convention, this.clock, this.threadFactory);
        }
    }
}

