/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.newrelic;

import com.newrelic.api.agent.Agent;
import com.newrelic.api.agent.NewRelic;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MissingRequiredConfigurationException;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.StringUtils;
import io.micrometer.newrelic.NewRelicClientProvider;
import io.micrometer.newrelic.NewRelicConfig;
import io.micrometer.newrelic.NewRelicMeterRegistry;
import io.micrometer.newrelic.NewRelicNamingConvention;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewRelicInsightsAgentClientProvider
implements NewRelicClientProvider {
    private final Logger logger = LoggerFactory.getLogger(NewRelicInsightsAgentClientProvider.class);
    private final NewRelicConfig config;
    private final Agent newRelicAgent;
    private final NamingConvention namingConvention;

    public NewRelicInsightsAgentClientProvider(NewRelicConfig config) {
        this(config, NewRelic.getAgent(), new NewRelicNamingConvention());
    }

    public NewRelicInsightsAgentClientProvider(NewRelicConfig config, Agent newRelicAgent, NamingConvention namingConvention) {
        if (!config.meterNameEventTypeEnabled() && StringUtils.isEmpty((String)config.eventType())) {
            throw new MissingRequiredConfigurationException("eventType must be set to report metrics to New Relic");
        }
        this.config = config;
        this.newRelicAgent = newRelicAgent;
        this.namingConvention = namingConvention;
    }

    @Override
    public void publish(NewRelicMeterRegistry meterRegistry) {
        for (Meter meter2 : meterRegistry.getMeters()) {
            this.sendEvents(meter2.getId(), (Map)meter2.match(gauge -> this.writeGauge((Gauge)gauge), counter -> this.writeCounter((Counter)counter), timer -> this.writeTimer((Timer)timer), distributionSummary -> this.writeSummary((DistributionSummary)distributionSummary), longTaskTimer -> this.writeLongTaskTimer((LongTaskTimer)longTaskTimer), timeGauge -> this.writeTimeGauge((TimeGauge)timeGauge), functionCounter -> this.writeFunctionCounter((FunctionCounter)functionCounter), functionTimer -> this.writeFunctionTimer((FunctionTimer)functionTimer), meter -> this.writeMeter((Meter)meter)));
        }
    }

    @Override
    public Map<String, Object> writeLongTaskTimer(LongTaskTimer timer) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        TimeUnit timeUnit = TimeUnit.valueOf(timer.getId().getBaseUnit().toUpperCase());
        this.addAttribute("activeTasks", timer.activeTasks(), attributes);
        this.addAttribute("duration", timer.duration(timeUnit), attributes);
        this.addAttribute("timeUnit", timeUnit.name().toLowerCase(), attributes);
        this.addMeterAsAttributes(timer.getId(), attributes);
        return attributes;
    }

    @Override
    public Map<String, Object> writeFunctionCounter(FunctionCounter counter) {
        return this.writeCounterValues(counter.getId(), counter.count());
    }

    @Override
    public Map<String, Object> writeCounter(Counter counter) {
        return this.writeCounterValues(counter.getId(), counter.count());
    }

    private Map<String, Object> writeCounterValues(Meter.Id id, double count) {
        if (!Double.isFinite(count)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        this.addAttribute("throughput", count, attributes);
        this.addMeterAsAttributes(id, attributes);
        return attributes;
    }

    @Override
    public Map<String, Object> writeGauge(Gauge gauge) {
        double value = gauge.value();
        if (!Double.isFinite(value)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        this.addAttribute("value", value, attributes);
        this.addMeterAsAttributes(gauge.getId(), attributes);
        return attributes;
    }

    @Override
    public Map<String, Object> writeTimeGauge(TimeGauge gauge) {
        double value = gauge.value();
        if (!Double.isFinite(value)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        this.addAttribute("value", value, attributes);
        this.addAttribute("timeUnit", gauge.baseTimeUnit().name().toLowerCase(), attributes);
        this.addMeterAsAttributes(gauge.getId(), attributes);
        return attributes;
    }

    @Override
    public Map<String, Object> writeSummary(DistributionSummary summary) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        this.addAttribute("count", summary.count(), attributes);
        this.addAttribute("avg", summary.mean(), attributes);
        this.addAttribute("total", summary.totalAmount(), attributes);
        this.addAttribute("max", summary.max(), attributes);
        this.addMeterAsAttributes(summary.getId(), attributes);
        return attributes;
    }

    @Override
    public Map<String, Object> writeTimer(Timer timer) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        TimeUnit timeUnit = timer.baseTimeUnit();
        this.addAttribute("count", timer.count(), attributes);
        this.addAttribute("avg", timer.mean(timeUnit), attributes);
        this.addAttribute("totalTime", timer.totalTime(timeUnit), attributes);
        this.addAttribute("max", timer.max(timeUnit), attributes);
        this.addAttribute("timeUnit", timeUnit.name().toLowerCase(), attributes);
        this.addMeterAsAttributes(timer.getId(), attributes);
        return attributes;
    }

    @Override
    public Map<String, Object> writeFunctionTimer(FunctionTimer timer) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        TimeUnit timeUnit = timer.baseTimeUnit();
        this.addAttribute("count", timer.count(), attributes);
        this.addAttribute("avg", timer.mean(timeUnit), attributes);
        this.addAttribute("totalTime", timer.totalTime(timeUnit), attributes);
        this.addAttribute("timeUnit", timeUnit.name().toLowerCase(), attributes);
        this.addMeterAsAttributes(timer.getId(), attributes);
        return attributes;
    }

    @Override
    public Map<String, Object> writeMeter(Meter meter) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (Measurement measurement : meter.measure()) {
            double value = measurement.getValue();
            if (!Double.isFinite(value)) continue;
            this.addAttribute(measurement.getStatistic().getTagValueRepresentation(), value, attributes);
        }
        if (attributes.isEmpty()) {
            return attributes;
        }
        this.addMeterAsAttributes(meter.getId(), attributes);
        return attributes;
    }

    private void addMeterAsAttributes(Meter.Id id, Map<String, Object> attributes) {
        if (!this.config.meterNameEventTypeEnabled()) {
            String name = id.getConventionName(this.namingConvention);
            attributes.put("metricName", name);
            attributes.put("metricType", id.getType().toString());
        }
        for (Tag tag : id.getConventionTags(this.namingConvention)) {
            attributes.put(tag.getKey(), tag.getValue());
        }
    }

    private void addAttribute(String key, Number value, Map<String, Object> attributes) {
        if (Math.floor(value.doubleValue()) == value.doubleValue()) {
            attributes.put(this.namingConvention.tagKey(key), value.intValue());
        } else {
            attributes.put(this.namingConvention.tagKey(key), value.doubleValue());
        }
    }

    private void addAttribute(String key, String value, Map<String, Object> attributes) {
        attributes.put(this.namingConvention.tagKey(key), this.namingConvention.tagValue(value));
    }

    void sendEvents(Meter.Id id, Map<String, Object> attributes) {
        if (attributes != null && !attributes.isEmpty()) {
            String eventType = this.getEventType(id, this.config, this.namingConvention);
            try {
                this.newRelicAgent.getInsights().recordCustomEvent(eventType, attributes);
            }
            catch (Throwable e) {
                this.logger.warn("failed to send metrics to new relic", e);
            }
        }
    }
}

