/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.newrelic;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MissingRequiredConfigurationException;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import io.micrometer.core.instrument.util.StringUtils;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.newrelic.NewRelicConfig;
import io.micrometer.newrelic.NewRelicNamingConvention;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewRelicMeterRegistry
extends StepMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("new-relic-metrics-publisher");
    private final NewRelicConfig config;
    private final HttpSender httpClient;
    private final Logger logger = LoggerFactory.getLogger(NewRelicMeterRegistry.class);

    public NewRelicMeterRegistry(NewRelicConfig config, Clock clock) {
        this(config, clock, DEFAULT_THREAD_FACTORY, (HttpSender)new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout()));
    }

    @Deprecated
    public NewRelicMeterRegistry(NewRelicConfig config, Clock clock, ThreadFactory threadFactory) {
        this(config, clock, threadFactory, (HttpSender)new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout()));
    }

    NewRelicMeterRegistry(NewRelicConfig config, Clock clock, ThreadFactory threadFactory, HttpSender httpClient) {
        super((StepRegistryConfig)config, clock);
        if (!config.meterNameEventTypeEnabled() && StringUtils.isEmpty((String)config.eventType())) {
            throw new MissingRequiredConfigurationException("eventType must be set to report metrics to New Relic");
        }
        if (StringUtils.isEmpty((String)config.accountId())) {
            throw new MissingRequiredConfigurationException("accountId must be set to report metrics to New Relic");
        }
        if (StringUtils.isEmpty((String)config.apiKey())) {
            throw new MissingRequiredConfigurationException("apiKey must be set to report metrics to New Relic");
        }
        if (StringUtils.isEmpty((String)config.uri())) {
            throw new MissingRequiredConfigurationException("uri must be set to report metrics to New Relic");
        }
        this.config = config;
        this.httpClient = httpClient;
        this.config().namingConvention((NamingConvention)new NewRelicNamingConvention());
        this.start(threadFactory);
    }

    public static Builder builder(NewRelicConfig config) {
        return new Builder(config);
    }

    public void start(ThreadFactory threadFactory) {
        if (this.config.enabled()) {
            this.logger.info("publishing metrics to new relic every " + TimeUtils.format((Duration)this.config.step()));
        }
        super.start(threadFactory);
    }

    protected void publish() {
        String insightsEndpoint = this.config.uri() + "/v1/accounts/" + this.config.accountId() + "/events";
        for (List batch : MeterPartition.partition((MeterRegistry)this, (int)Math.min(this.config.batchSize(), 1000))) {
            this.sendEvents(insightsEndpoint, batch.stream().flatMap(meter -> (Stream)meter.match(this::writeGauge, this::writeCounter, this::writeTimer, this::writeSummary, this::writeLongTaskTimer, this::writeTimeGauge, this::writeFunctionCounter, this::writeFunctionTimer, this::writeMeter)));
        }
    }

    private Stream<String> writeLongTaskTimer(LongTaskTimer ltt) {
        return Stream.of(this.event(ltt.getId(), new Attribute("activeTasks", ltt.activeTasks()), new Attribute("duration", ltt.duration(this.getBaseTimeUnit())), new Attribute("timeUnit", this.getBaseTimeUnit().name().toLowerCase())));
    }

    Stream<String> writeFunctionCounter(FunctionCounter counter) {
        double count = counter.count();
        if (Double.isFinite(count)) {
            return Stream.of(this.event(counter.getId(), new Attribute("throughput", count)));
        }
        return Stream.empty();
    }

    private Stream<String> writeCounter(Counter counter) {
        return Stream.of(this.event(counter.getId(), new Attribute("throughput", counter.count())));
    }

    Stream<String> writeGauge(Gauge gauge) {
        Double value = gauge.value();
        if (Double.isFinite(value)) {
            return Stream.of(this.event(gauge.getId(), new Attribute("value", value)));
        }
        return Stream.empty();
    }

    Stream<String> writeTimeGauge(TimeGauge gauge) {
        Double value = gauge.value(this.getBaseTimeUnit());
        if (Double.isFinite(value)) {
            return Stream.of(this.event(gauge.getId(), new Attribute("value", value), new Attribute("timeUnit", this.getBaseTimeUnit().name().toLowerCase())));
        }
        return Stream.empty();
    }

    private Stream<String> writeSummary(DistributionSummary summary) {
        return Stream.of(this.event(summary.getId(), new Attribute("count", summary.count()), new Attribute("avg", summary.mean()), new Attribute("total", summary.totalAmount()), new Attribute("max", summary.max())));
    }

    private Stream<String> writeTimer(Timer timer) {
        return Stream.of(this.event(timer.getId(), new Attribute("count", timer.count()), new Attribute("avg", timer.mean(this.getBaseTimeUnit())), new Attribute("totalTime", timer.totalTime(this.getBaseTimeUnit())), new Attribute("max", timer.max(this.getBaseTimeUnit())), new Attribute("timeUnit", this.getBaseTimeUnit().name().toLowerCase())));
    }

    private Stream<String> writeFunctionTimer(FunctionTimer timer) {
        return Stream.of(this.event(timer.getId(), new Attribute("count", timer.count()), new Attribute("avg", timer.mean(this.getBaseTimeUnit())), new Attribute("totalTime", timer.totalTime(this.getBaseTimeUnit())), new Attribute("timeUnit", this.getBaseTimeUnit().name().toLowerCase())));
    }

    Stream<String> writeMeter(Meter meter) {
        HashMap<String, Attribute> attributes = new HashMap<String, Attribute>();
        for (Measurement measurement : meter.measure()) {
            double value = measurement.getValue();
            if (!Double.isFinite(value)) continue;
            String name = measurement.getStatistic().getTagValueRepresentation();
            attributes.put(name, new Attribute(name, value));
        }
        if (attributes.isEmpty()) {
            return Stream.empty();
        }
        return Stream.of(this.event(meter.getId(), attributes.values().toArray(new Attribute[0])));
    }

    private String event(Meter.Id id, Attribute ... attributes) {
        if (!this.config.meterNameEventTypeEnabled()) {
            int size = attributes.length;
            Attribute[] newAttrs = Arrays.copyOf(attributes, size + 2);
            String name = id.getConventionName(this.config().namingConvention());
            newAttrs[size] = new Attribute("metricName", name);
            newAttrs[size + 1] = new Attribute("metricType", id.getType().toString());
            return this.event(id, (Iterable<Tag>)Tags.empty(), newAttrs);
        }
        return this.event(id, (Iterable<Tag>)Tags.empty(), attributes);
    }

    private String event(Meter.Id id, Iterable<Tag> extraTags, Attribute ... attributes) {
        StringBuilder tagsJson = new StringBuilder();
        for (Object tag : this.getConventionTags(id)) {
            tagsJson.append(",\"").append(StringEscapeUtils.escapeJson((String)tag.getKey())).append("\":\"").append(StringEscapeUtils.escapeJson((String)tag.getValue())).append("\"");
        }
        NamingConvention convention = this.config().namingConvention();
        for (Tag tag : extraTags) {
            tagsJson.append(",\"").append(StringEscapeUtils.escapeJson((String)convention.tagKey(tag.getKey()))).append("\":\"").append(StringEscapeUtils.escapeJson((String)convention.tagValue(tag.getValue()))).append("\"");
        }
        String eventType = this.getEventType(id);
        return Arrays.stream(attributes).map(attr -> attr.getValue() instanceof Number ? ",\"" + attr.getName() + "\":" + DoubleFormat.wholeOrDecimal((double)((Number)attr.getValue()).doubleValue()) : ",\"" + attr.getName() + "\":\"" + convention.tagValue(attr.getValue().toString()) + "\"").collect(Collectors.joining("", "{\"eventType\":\"" + StringEscapeUtils.escapeJson((String)eventType) + "\"", tagsJson + "}"));
    }

    private String getEventType(Meter.Id id) {
        if (this.config.meterNameEventTypeEnabled()) {
            return id.getConventionName(this.config().namingConvention());
        }
        return this.config.eventType();
    }

    private void sendEvents(String insightsEndpoint, Stream<String> events) {
        try {
            AtomicInteger totalEvents = new AtomicInteger();
            this.httpClient.post(insightsEndpoint).withHeader("X-Insert-Key", this.config.apiKey()).withJsonContent(events.peek(ev -> totalEvents.incrementAndGet()).collect(Collectors.joining(",", "[", "]"))).send().onSuccess(response -> this.logger.debug("successfully sent {} metrics to New Relic.", (Object)totalEvents)).onError(response -> this.logger.error("failed to send metrics to new relic: http {} {}", (Object)response.code(), (Object)response.body()));
        }
        catch (Throwable e) {
            this.logger.warn("failed to send metrics to new relic", e);
        }
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    static /* synthetic */ ThreadFactory access$100() {
        return DEFAULT_THREAD_FACTORY;
    }

    public static class Builder {
        private final NewRelicConfig config;
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = NewRelicMeterRegistry.access$100();
        private HttpSender httpClient;

        Builder(NewRelicConfig config) {
            this.config = config;
            this.httpClient = new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout());
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder httpClient(HttpSender httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public NewRelicMeterRegistry build() {
            return new NewRelicMeterRegistry(this.config, this.clock, this.threadFactory, this.httpClient);
        }
    }

    private class Attribute {
        private final String name;
        private final Object value;

        private Attribute(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

