/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.newrelic;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.HistogramSnapshot;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.ValueAtPercentile;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.newrelic.NewRelicConfig;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Incubating(since="1.0.0-rc.5")
public class NewRelicMeterRegistry
extends StepMeterRegistry {
    private final NewRelicConfig config;
    private final ObjectMapper mapper = new ObjectMapper();
    private final Logger logger = LoggerFactory.getLogger(NewRelicMeterRegistry.class);

    public NewRelicMeterRegistry(NewRelicConfig config, Clock clock) {
        super((StepRegistryConfig)config, clock);
        this.config = config;
        this.config().namingConvention(NamingConvention.camelCase);
        this.start();
    }

    protected void publish() {
        try {
            URL insightsEndpoint = URI.create(this.config.uri() + "/v1/accounts/" + this.config.accountId() + "/events").toURL();
            int batchSize = Math.min(this.config.batchSize(), 1000);
            ArrayList<Event> events = new ArrayList<Event>();
            for (Meter meter : this.getMeters()) {
                HistogramSnapshot t;
                Meter.Id id = meter.getId();
                if (meter instanceof Timer) {
                    t = ((Timer)meter).takeSnapshot(false);
                    events.add(this.event(id, "count", t.count(), new String[0]));
                    events.add(this.event(id, "sum", t.total(this.getBaseTimeUnit()), new String[0]));
                    events.add(this.event(id, "avg", t.mean(this.getBaseTimeUnit()), new String[0]));
                    events.add(this.event(id, "max", t.max(this.getBaseTimeUnit()), new String[0]));
                    for (ValueAtPercentile valueAtPercentile : t.percentileValues()) {
                        events.add(this.event(id, "percentile", valueAtPercentile.value(this.getBaseTimeUnit()), "phi", DoubleFormat.toString((double)valueAtPercentile.percentile())));
                    }
                } else if (meter instanceof FunctionTimer) {
                    t = (FunctionTimer)meter;
                    events.add(this.event(id, "count", t.count(), new String[0]));
                    events.add(this.event(id, "sum", t.count(), new String[0]));
                    events.add(this.event(id, "mean", t.mean(this.getBaseTimeUnit()), new String[0]));
                } else if (meter instanceof DistributionSummary) {
                    t = ((DistributionSummary)meter).takeSnapshot(false);
                    events.add(this.event(id, "count", t.count(), new String[0]));
                    events.add(this.event(id, "sum", t.total(), new String[0]));
                    events.add(this.event(id, "avg", t.mean(), new String[0]));
                    events.add(this.event(id, "max", t.max(), new String[0]));
                    for (ValueAtPercentile valueAtPercentile : t.percentileValues()) {
                        events.add(this.event(id, "percentile", valueAtPercentile.value(), "phi", DoubleFormat.toString((double)valueAtPercentile.percentile())));
                    }
                } else {
                    for (Measurement measurement : meter.measure()) {
                        events.add(this.event(id, measurement.getStatistic().toString(), measurement.getValue(), new String[0]));
                    }
                }
                if (events.size() > batchSize) {
                    this.sendEvents(insightsEndpoint, events.subList(0, batchSize));
                    events = new ArrayList(events.subList(batchSize, events.size()));
                    continue;
                }
                if (events.size() != batchSize) continue;
                this.sendEvents(insightsEndpoint, events);
                events = new ArrayList();
            }
            if (!events.isEmpty()) {
                this.sendEvents(insightsEndpoint, events);
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed New Relic insights endpoint, see '" + this.config.prefix() + ".uri'", e);
        }
    }

    private Event event(Meter.Id id, String statistic, Number value, String ... additionalTags) {
        Event event = new Event();
        event.put("eventType", this.getConventionName(id));
        event.put("statistic", statistic);
        event.put("value", value);
        for (int i = 0; i < additionalTags.length; i += 2) {
            event.put(additionalTags[i], additionalTags[i + 1]);
        }
        id.getTags().forEach(t -> event.put(t.getKey(), t.getValue()));
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvents(URL insightsEndpoint, List<Event> events) {
        block32: {
            HttpURLConnection con = null;
            try {
                con = (HttpURLConnection)insightsEndpoint.openConnection();
                con.setConnectTimeout((int)this.config.connectTimeout().toMillis());
                con.setReadTimeout((int)this.config.readTimeout().toMillis());
                con.setRequestMethod("POST");
                con.setRequestProperty("Content-Type", "application/json");
                con.setRequestProperty("X-Insert-Key", this.config.apiKey());
                con.setDoOutput(true);
                String body = this.mapper.writeValueAsString(events);
                try (OutputStream os = con.getOutputStream();){
                    os.write(body.getBytes());
                    os.flush();
                }
                int status = con.getResponseCode();
                if (status >= 200 && status < 300) {
                    this.logger.info("successfully sent {} events to New Relic", (Object)events.size());
                    break block32;
                }
                if (status >= 400) {
                    try (InputStream in = con.getErrorStream();){
                        this.logger.error("failed to send metrics: " + new BufferedReader(new InputStreamReader(in)).lines().collect(Collectors.joining("\n")));
                        break block32;
                    }
                }
                this.logger.error("failed to send metrics: http " + status);
            }
            catch (Throwable e) {
                this.logger.warn("failed to send metrics", e);
            }
            finally {
                this.quietlyCloseUrlConnection(con);
            }
        }
    }

    private void quietlyCloseUrlConnection(HttpURLConnection con) {
        if (con == null) {
            return;
        }
        try {
            con.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    private class Event
    extends HashMap<String, Object> {
        private Event() {
        }
    }
}

