/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.kairos;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.kairos.KairosConfig;
import io.micrometer.kairos.KairosNamingConvention;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KairosMeterRegistry
extends StepMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("kairos-metrics-publisher");
    private final Logger logger = LoggerFactory.getLogger(KairosMeterRegistry.class);
    private final KairosConfig config;
    private final HttpSender httpClient;

    public KairosMeterRegistry(KairosConfig config, Clock clock) {
        this(config, clock, DEFAULT_THREAD_FACTORY, (HttpSender)new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout()));
    }

    private KairosMeterRegistry(KairosConfig config, Clock clock, ThreadFactory threadFactory, HttpSender httpClient) {
        super((StepRegistryConfig)config, clock);
        this.config().namingConvention((NamingConvention)new KairosNamingConvention());
        this.config = config;
        this.httpClient = httpClient;
        this.start(threadFactory);
    }

    public static Builder builder(KairosConfig config) {
        return new Builder(config);
    }

    public void start(ThreadFactory threadFactory) {
        if (this.config.enabled()) {
            this.logger.info("publishing metrics to kairos every " + TimeUtils.format((Duration)this.config.step()));
        }
        super.start(threadFactory);
    }

    protected void publish() {
        for (List batch : MeterPartition.partition((MeterRegistry)this, (int)this.config.batchSize())) {
            try {
                this.httpClient.post(this.config.uri()).withBasicAuthentication(this.config.userName(), this.config.password()).withJsonContent(batch.stream().flatMap(m -> (Stream)m.match(this::writeGauge, this::writeCounter, this::writeTimer, this::writeSummary, this::writeLongTaskTimer, this::writeTimeGauge, this::writeFunctionCounter, this::writeFunctionTimer, this::writeCustomMetric)).collect(Collectors.joining(",", "[", "]"))).send().onSuccess(response -> this.logger.debug("successfully sent {} metrics to kairos.", (Object)batch.size())).onError(response -> this.logger.error("failed to send metrics to kairos: {}", (Object)response.body()));
            }
            catch (Throwable t) {
                this.logger.warn("failed to send metrics to kairos", t);
            }
        }
    }

    Stream<String> writeSummary(DistributionSummary summary) {
        long wallTime = this.config().clock().wallTime();
        return Stream.of(this.writeMetric(this.idWithSuffix(summary.getId(), "count"), wallTime, summary.count()), this.writeMetric(this.idWithSuffix(summary.getId(), "avg"), wallTime, summary.mean()), this.writeMetric(this.idWithSuffix(summary.getId(), "sum"), wallTime, summary.totalAmount()), this.writeMetric(this.idWithSuffix(summary.getId(), "max"), wallTime, summary.max()));
    }

    Stream<String> writeFunctionTimer(FunctionTimer timer) {
        long wallTime = this.config().clock().wallTime();
        return Stream.of(this.writeMetric(this.idWithSuffix(timer.getId(), "count"), wallTime, timer.count()), this.writeMetric(this.idWithSuffix(timer.getId(), "avg"), wallTime, timer.mean(this.getBaseTimeUnit())), this.writeMetric(this.idWithSuffix(timer.getId(), "sum"), wallTime, timer.totalTime(this.getBaseTimeUnit())));
    }

    Stream<String> writeTimer(Timer timer) {
        long wallTime = this.config().clock().wallTime();
        return Stream.of(this.writeMetric(this.idWithSuffix(timer.getId(), "count"), wallTime, timer.count()), this.writeMetric(this.idWithSuffix(timer.getId(), "max"), wallTime, timer.max(this.getBaseTimeUnit())), this.writeMetric(this.idWithSuffix(timer.getId(), "avg"), wallTime, timer.mean(this.getBaseTimeUnit())), this.writeMetric(this.idWithSuffix(timer.getId(), "sum"), wallTime, timer.totalTime(this.getBaseTimeUnit())));
    }

    Stream<String> writeFunctionCounter(FunctionCounter counter) {
        double count = counter.count();
        if (Double.isFinite(count)) {
            return Stream.of(this.writeMetric(counter.getId(), this.config().clock().wallTime(), count));
        }
        return Stream.empty();
    }

    Stream<String> writeCounter(Counter counter) {
        return Stream.of(this.writeMetric(counter.getId(), this.config().clock().wallTime(), counter.count()));
    }

    Stream<String> writeGauge(Gauge gauge) {
        Double value = gauge.value();
        if (Double.isFinite(value)) {
            return Stream.of(this.writeMetric(gauge.getId(), this.config().clock().wallTime(), value));
        }
        return Stream.empty();
    }

    Stream<String> writeTimeGauge(TimeGauge timeGauge) {
        Double value = timeGauge.value(this.getBaseTimeUnit());
        if (Double.isFinite(value)) {
            return Stream.of(this.writeMetric(timeGauge.getId(), this.config().clock().wallTime(), value));
        }
        return Stream.empty();
    }

    Stream<String> writeLongTaskTimer(LongTaskTimer timer) {
        long wallTime = this.config().clock().wallTime();
        return Stream.of(this.writeMetric(this.idWithSuffix(timer.getId(), "activeTasks"), wallTime, timer.activeTasks()), this.writeMetric(this.idWithSuffix(timer.getId(), "duration"), wallTime, timer.duration(this.getBaseTimeUnit())));
    }

    Stream<String> writeCustomMetric(Meter meter) {
        long wallTime = this.config().clock().wallTime();
        List tags = this.getConventionTags(meter.getId());
        ArrayList<String> metrics = new ArrayList<String>();
        for (Measurement measurement : meter.measure()) {
            double value = measurement.getValue();
            if (!Double.isFinite(value)) continue;
            metrics.add(new KairosMetricBuilder().field("name", measurement.getStatistic().getTagValueRepresentation()).datapoints(wallTime, value).tags(tags).build());
        }
        return metrics.stream();
    }

    String writeMetric(Meter.Id id, long wallTime, double value) {
        return new KairosMetricBuilder().field("name", this.getConventionName(id)).datapoints(wallTime, value).tags(this.getConventionTags(id)).build();
    }

    private Meter.Id idWithSuffix(Meter.Id id, String suffix) {
        return id.withName(id.getName() + "." + suffix);
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    static /* synthetic */ ThreadFactory access$100() {
        return DEFAULT_THREAD_FACTORY;
    }

    public static class Builder {
        private final KairosConfig config;
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = KairosMeterRegistry.access$100();
        private HttpSender httpClient;

        Builder(KairosConfig config) {
            this.config = config;
            this.httpClient = new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout());
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder httpClient(HttpSender httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public KairosMeterRegistry build() {
            return new KairosMeterRegistry(this.config, this.clock, this.threadFactory, this.httpClient);
        }
    }

    private static class KairosMetricBuilder {
        private final StringBuilder sb = new StringBuilder("{");

        private KairosMetricBuilder() {
        }

        KairosMetricBuilder field(String key, String value) {
            if (this.sb.length() > 1) {
                this.sb.append(',');
            }
            this.sb.append('\"').append(StringEscapeUtils.escapeJson((String)key)).append("\":\"").append(StringEscapeUtils.escapeJson((String)value)).append('\"');
            return this;
        }

        KairosMetricBuilder datapoints(long wallTime, double value) {
            this.sb.append(",\"datapoints\":[[").append(wallTime).append(',').append(DoubleFormat.wholeOrDecimal((double)value)).append("]]");
            return this;
        }

        KairosMetricBuilder tags(List<Tag> tags) {
            KairosMetricBuilder tagBuilder = new KairosMetricBuilder();
            if (tags.isEmpty()) {
                try {
                    tagBuilder.field("hostname", InetAddress.getLocalHost().getHostName());
                }
                catch (UnknownHostException unknownHostException) {}
            } else {
                for (Tag tag : tags) {
                    tagBuilder.field(tag.getKey(), tag.getValue());
                }
            }
            this.sb.append(",\"tags\":").append(tagBuilder.build());
            return this;
        }

        String build() {
            return this.sb.append('}').toString();
        }
    }
}

