/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.kairos;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import io.micrometer.core.lang.Nullable;
import java.util.regex.Pattern;

public class KairosNamingConvention
implements NamingConvention {
    private static final Pattern BLACKLISTED_CHARS = Pattern.compile("[{}():,=\\[\\]]");
    private final NamingConvention delegate;

    public KairosNamingConvention() {
        this(NamingConvention.snakeCase);
    }

    public KairosNamingConvention(NamingConvention delegate) {
        this.delegate = delegate;
    }

    private String format(String name) {
        String normalized = StringEscapeUtils.escapeJson((String)name);
        return BLACKLISTED_CHARS.matcher(normalized).replaceAll("_");
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        return this.format(this.delegate.name(name, type, baseUnit));
    }

    public String tagKey(String key) {
        return this.format(this.delegate.tagKey(key));
    }

    public String tagValue(String value) {
        return this.format(this.delegate.tagValue(value));
    }
}

