/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.graphite;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import java.text.Normalizer;
import java.util.regex.Pattern;

public class GraphiteNamingConvention
implements NamingConvention {
    private static final Pattern blacklistedChars = Pattern.compile("[{}(),=\\[\\]/]");

    public String name(String name, Meter.Type type, String baseUnit) {
        return this.format(name);
    }

    public String tagKey(String key) {
        return this.format(key);
    }

    public String tagValue(String value) {
        return this.format(value);
    }

    private String format(String name) {
        String sanitized = Normalizer.normalize(name, Normalizer.Form.NFKD);
        sanitized = NamingConvention.camelCase.tagKey(sanitized);
        return blacklistedChars.matcher(sanitized).replaceAll("_");
    }
}

