/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.graphite;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import java.util.Arrays;
import java.util.List;

public class GraphiteHierarchicalNameMapper
implements HierarchicalNameMapper {
    private final List<String> tagsAsPrefix;

    public GraphiteHierarchicalNameMapper(String ... tagsAsPrefix) {
        this.tagsAsPrefix = Arrays.asList(tagsAsPrefix);
    }

    public String toHierarchicalName(Meter.Id id, NamingConvention convention) {
        StringBuilder hierarchicalName = new StringBuilder();
        for (String tagKey : this.tagsAsPrefix) {
            String tagValue = id.getTag(tagKey);
            if (tagValue == null) continue;
            hierarchicalName.append(convention.tagValue(tagValue)).append(".");
        }
        hierarchicalName.append(id.getConventionName(convention));
        for (Tag tag : id.getTags()) {
            if (this.tagsAsPrefix.contains(tag.getKey())) continue;
            hierarchicalName.append('.').append(this.sanitize(convention.tagKey(tag.getKey()))).append('.').append(this.sanitize(convention.tagValue(tag.getValue())));
        }
        return hierarchicalName.toString();
    }

    private String sanitize(String value) {
        return value.replace(" ", "_");
    }
}

