/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.graphite;

import com.codahale.metrics.Clock;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.graphite.GraphiteSender;
import com.codahale.metrics.graphite.GraphiteUDP;
import com.codahale.metrics.graphite.PickledGraphite;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.dropwizard.DropwizardClock;
import io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.core.lang.Nullable;
import io.micrometer.graphite.GraphiteConfig;
import io.micrometer.graphite.GraphiteHierarchicalNameMapper;
import io.micrometer.graphite.GraphiteNamingConvention;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;

public class GraphiteMeterRegistry
extends DropwizardMeterRegistry {
    private final GraphiteReporter reporter;
    private final GraphiteConfig config;

    public GraphiteMeterRegistry(GraphiteConfig config, io.micrometer.core.instrument.Clock clock) {
        this(config, clock, new GraphiteHierarchicalNameMapper(config.tagsAsPrefix()));
    }

    public GraphiteMeterRegistry(GraphiteConfig config, io.micrometer.core.instrument.Clock clock, HierarchicalNameMapper nameMapper) {
        this(config, clock, nameMapper, new MetricRegistry());
    }

    public GraphiteMeterRegistry(GraphiteConfig config, io.micrometer.core.instrument.Clock clock, HierarchicalNameMapper nameMapper, MetricRegistry metricRegistry) {
        this(config, clock, nameMapper, metricRegistry, GraphiteMeterRegistry.defaultGraphiteReporter(config, clock, metricRegistry));
    }

    public GraphiteMeterRegistry(GraphiteConfig config, io.micrometer.core.instrument.Clock clock, HierarchicalNameMapper nameMapper, MetricRegistry metricRegistry, GraphiteReporter reporter) {
        super((DropwizardConfig)config, metricRegistry, nameMapper, clock);
        this.config = config;
        this.config().namingConvention((NamingConvention)new GraphiteNamingConvention());
        this.reporter = reporter;
        if (config.enabled()) {
            this.start();
        }
    }

    private static GraphiteReporter defaultGraphiteReporter(GraphiteConfig config, io.micrometer.core.instrument.Clock clock, MetricRegistry metricRegistry) {
        Graphite sender;
        switch (config.protocol()) {
            case PLAINTEXT: {
                sender = new Graphite(new InetSocketAddress(config.host(), config.port()));
                break;
            }
            case UDP: {
                sender = new GraphiteUDP(new InetSocketAddress(config.host(), config.port()));
                break;
            }
            default: {
                sender = new PickledGraphite(new InetSocketAddress(config.host(), config.port()));
            }
        }
        return GraphiteReporter.forRegistry((MetricRegistry)metricRegistry).withClock((Clock)new DropwizardClock(clock)).convertRatesTo(config.rateUnits()).convertDurationsTo(config.durationUnits()).build((GraphiteSender)sender);
    }

    public void stop() {
        this.reporter.stop();
    }

    public void start() {
        this.reporter.start(this.config.step().getSeconds(), TimeUnit.SECONDS);
    }

    public void close() {
        this.reporter.report();
        this.stop();
        super.close();
    }

    @Nullable
    protected Double nullGaugeValue() {
        return null;
    }
}

