/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.graphite;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.graphite.GraphiteSender;
import com.codahale.metrics.graphite.PickledGraphite;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.graphite.GraphiteConfig;
import io.micrometer.graphite.GraphiteNamingConvention;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;

public class GraphiteMeterRegistry
extends DropwizardMeterRegistry {
    private final GraphiteReporter reporter;
    private final GraphiteConfig config;

    public GraphiteMeterRegistry() {
        this(System::getProperty);
    }

    public GraphiteMeterRegistry(GraphiteConfig config) {
        this(config, HierarchicalNameMapper.DEFAULT, Clock.SYSTEM);
    }

    public GraphiteMeterRegistry(GraphiteConfig config, HierarchicalNameMapper nameMapper, Clock clock) {
        super((DropwizardConfig)config, nameMapper, clock);
        Graphite sender;
        this.config = config;
        this.config().namingConvention((NamingConvention)new GraphiteNamingConvention());
        switch (config.protocol()) {
            case Plaintext: {
                sender = new Graphite(new InetSocketAddress(config.host(), config.port()));
                break;
            }
            default: {
                sender = new PickledGraphite(new InetSocketAddress(config.host(), config.port()));
            }
        }
        this.reporter = GraphiteReporter.forRegistry((MetricRegistry)this.getDropwizardRegistry()).convertRatesTo(config.rateUnits()).convertDurationsTo(config.durationUnits()).build((GraphiteSender)sender);
        if (config.enabled()) {
            this.start();
        }
    }

    public void stop() {
        this.reporter.stop();
    }

    public void start() {
        this.reporter.start(this.config.step().getSeconds(), TimeUnit.SECONDS);
    }
}

