/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.dynatrace.types;

import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.dynatrace.types.DynatraceSummary;
import io.micrometer.dynatrace.types.DynatraceSummarySnapshot;
import io.micrometer.dynatrace.types.DynatraceSummarySnapshotSupport;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynatraceDistributionSummary
extends AbstractDistributionSummary
implements DynatraceSummarySnapshotSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynatraceDistributionSummary.class);
    private static final DistributionStatisticConfig NOOP_HISTOGRAM_CONFIG = DistributionStatisticConfig.builder().percentilesHistogram(Boolean.valueOf(false)).percentiles(new double[0]).serviceLevelObjectives(new double[0]).build();
    private final DynatraceSummary summary = new DynatraceSummary();

    public DynatraceDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        super(id, clock, distributionStatisticConfig.merge(NOOP_HISTOGRAM_CONFIG), scale, false);
        if (distributionStatisticConfig.isPublishingPercentiles() || distributionStatisticConfig.isPublishingHistogram()) {
            LOGGER.warn("Histogram config on DistributionStatisticConfig is currently ignored. Collecting summary statistics.");
        }
    }

    protected void recordNonNegative(double amount) {
        this.summary.recordNonNegative(amount);
    }

    public long count() {
        return this.summary.getCount();
    }

    public double totalAmount() {
        return this.summary.getTotal();
    }

    public double max() {
        return this.summary.getMax();
    }

    @Deprecated
    public double min() {
        return this.summary.getMin();
    }

    @Override
    @Deprecated
    public boolean hasValues() {
        return this.count() > 0L;
    }

    @Override
    public DynatraceSummarySnapshot takeSummarySnapshot() {
        return this.summary.takeSummarySnapshot();
    }

    @Override
    public DynatraceSummarySnapshot takeSummarySnapshot(TimeUnit timeUnit) {
        LOGGER.debug("Called takeSummarySnapshot with a TimeUnit on a DistributionSummary. Ignoring TimeUnit.");
        return this.takeSummarySnapshot();
    }

    @Override
    public DynatraceSummarySnapshot takeSummarySnapshotAndReset() {
        return this.summary.takeSummarySnapshotAndReset();
    }

    @Override
    public DynatraceSummarySnapshot takeSummarySnapshotAndReset(TimeUnit unit) {
        LOGGER.debug("Called takeSummarySnapshotAndReset with a TimeUnit on a DistributionSummary. Ignoring TimeUnit.");
        return this.takeSummarySnapshotAndReset();
    }

    public HistogramSnapshot takeSnapshot() {
        LOGGER.warn("Called takeSnapshot on a Dynatrace Distribution Summary, no percentiles will be exported.");
        DynatraceSummarySnapshot dtSnapshot = this.takeSummarySnapshot();
        return HistogramSnapshot.empty((long)dtSnapshot.getCount(), (double)dtSnapshot.getTotal(), (double)dtSnapshot.getMax());
    }
}

