/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.dynatrace;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MissingRequiredConfigurationException;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.instrument.util.StringUtils;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.core.lang.Nullable;
import io.micrometer.dynatrace.DynatraceBatchedPayload;
import io.micrometer.dynatrace.DynatraceConfig;
import io.micrometer.dynatrace.DynatraceMetricDefinition;
import io.micrometer.dynatrace.DynatraceNamingConvention;
import io.micrometer.dynatrace.DynatraceTimeSeries;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynatraceMeterRegistry
extends StepMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("dynatrace-metrics-publisher");
    private static final int MAX_MESSAGE_SIZE = 15360;
    private final Logger logger = LoggerFactory.getLogger(DynatraceMeterRegistry.class);
    private final DynatraceConfig config;
    private final HttpSender httpClient;
    private final Set<String> createdCustomMetrics = ConcurrentHashMap.newKeySet();
    private final String customMetricEndpointTemplate;

    public DynatraceMeterRegistry(DynatraceConfig config, Clock clock) {
        this(config, clock, DEFAULT_THREAD_FACTORY, (HttpSender)new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout()));
    }

    private DynatraceMeterRegistry(DynatraceConfig config, Clock clock, ThreadFactory threadFactory, HttpSender httpClient) {
        super((StepRegistryConfig)config, clock);
        if (config.apiToken() == null) {
            throw new MissingRequiredConfigurationException("apiToken must be set to report metrics to Dynatrace");
        }
        if (config.deviceId() == null) {
            throw new MissingRequiredConfigurationException("deviceId must be set to report metrics to Dynatrace");
        }
        if (config.uri() == null) {
            throw new MissingRequiredConfigurationException("uri must be set to report metrics to Dynatrace");
        }
        this.config = config;
        this.httpClient = httpClient;
        this.config().namingConvention((NamingConvention)new DynatraceNamingConvention());
        this.customMetricEndpointTemplate = config.uri() + "/api/v1/timeseries/";
        this.start(threadFactory);
    }

    public static Builder builder(DynatraceConfig config) {
        return new Builder(config);
    }

    public void start(ThreadFactory threadFactory) {
        if (this.config.enabled()) {
            this.logger.info("publishing metrics to dynatrace every " + TimeUtils.format((Duration)this.config.step()));
        }
        super.start(threadFactory);
    }

    protected void publish() {
        String customDeviceMetricEndpoint = this.config.uri() + "/api/v1/entity/infrastructure/custom/" + this.config.deviceId() + "?api-token=" + this.config.apiToken();
        for (List batch : MeterPartition.partition((MeterRegistry)this, (int)this.config.batchSize())) {
            List series = batch.stream().flatMap(meter -> (Stream)meter.match(this::writeMeter, this::writeMeter, this::writeTimer, this::writeSummary, this::writeLongTaskTimer, this::writeMeter, this::writeMeter, this::writeFunctionTimer, this::writeMeter)).collect(Collectors.toList());
            series.stream().map(DynatraceCustomMetric::getMetricDefinition).filter(this::isCustomMetricNotCreated).forEach(this::putCustomMetric);
            if (this.createdCustomMetrics.isEmpty() || series.isEmpty()) continue;
            this.postCustomMetricValues(this.config.technologyType(), this.config.group(), series.stream().map(DynatraceCustomMetric::getTimeSeries).filter(this::isCustomMetricCreated).collect(Collectors.toList()), customDeviceMetricEndpoint);
        }
    }

    Stream<DynatraceCustomMetric> writeMeter(Meter meter) {
        long wallTime = this.clock.wallTime();
        return StreamSupport.stream(meter.measure().spliterator(), false).map(Measurement::getValue).filter(Double::isFinite).map(value -> this.createCustomMetric(meter.getId(), wallTime, (Number)value));
    }

    private Stream<DynatraceCustomMetric> writeLongTaskTimer(LongTaskTimer longTaskTimer) {
        long wallTime = this.clock.wallTime();
        Meter.Id id = longTaskTimer.getId();
        return Stream.of(this.createCustomMetric(this.idWithSuffix(id, "activeTasks"), wallTime, longTaskTimer.activeTasks(), DynatraceMetricDefinition.DynatraceUnit.Count), this.createCustomMetric(this.idWithSuffix(id, "count"), wallTime, longTaskTimer.duration(this.getBaseTimeUnit())));
    }

    private Stream<DynatraceCustomMetric> writeSummary(DistributionSummary summary) {
        long wallTime = this.clock.wallTime();
        Meter.Id id = summary.getId();
        HistogramSnapshot snapshot = summary.takeSnapshot();
        return Stream.of(this.createCustomMetric(this.idWithSuffix(id, "sum"), wallTime, snapshot.total(this.getBaseTimeUnit())), this.createCustomMetric(this.idWithSuffix(id, "count"), wallTime, snapshot.count(), DynatraceMetricDefinition.DynatraceUnit.Count), this.createCustomMetric(this.idWithSuffix(id, "avg"), wallTime, snapshot.mean(this.getBaseTimeUnit())), this.createCustomMetric(this.idWithSuffix(id, "max"), wallTime, snapshot.max(this.getBaseTimeUnit())));
    }

    private Stream<DynatraceCustomMetric> writeFunctionTimer(FunctionTimer timer) {
        long wallTime = this.clock.wallTime();
        Meter.Id id = timer.getId();
        return Stream.of(this.createCustomMetric(this.idWithSuffix(id, "count"), wallTime, timer.count(), DynatraceMetricDefinition.DynatraceUnit.Count), this.createCustomMetric(this.idWithSuffix(id, "avg"), wallTime, timer.mean(this.getBaseTimeUnit())), this.createCustomMetric(this.idWithSuffix(id, "sum"), wallTime, timer.totalTime(this.getBaseTimeUnit())));
    }

    private Stream<DynatraceCustomMetric> writeTimer(Timer timer) {
        long wallTime = this.clock.wallTime();
        Meter.Id id = timer.getId();
        HistogramSnapshot snapshot = timer.takeSnapshot();
        return Stream.of(this.createCustomMetric(this.idWithSuffix(id, "sum"), wallTime, snapshot.total(this.getBaseTimeUnit())), this.createCustomMetric(this.idWithSuffix(id, "count"), wallTime, snapshot.count(), DynatraceMetricDefinition.DynatraceUnit.Count), this.createCustomMetric(this.idWithSuffix(id, "avg"), wallTime, snapshot.mean(this.getBaseTimeUnit())), this.createCustomMetric(this.idWithSuffix(id, "max"), wallTime, snapshot.max(this.getBaseTimeUnit())));
    }

    private DynatraceCustomMetric createCustomMetric(Meter.Id id, long time, Number value) {
        return this.createCustomMetric(id, time, value, DynatraceMetricDefinition.DynatraceUnit.fromPlural(id.getBaseUnit()));
    }

    private DynatraceCustomMetric createCustomMetric(Meter.Id id, long time, Number value, @Nullable DynatraceMetricDefinition.DynatraceUnit unit) {
        String metricId = this.getConventionName(id);
        List tags = this.getConventionTags(id);
        return new DynatraceCustomMetric(new DynatraceMetricDefinition(metricId, id.getDescription(), unit, this.extractDimensions(tags), new String[]{this.config.technologyType()}, this.config.group()), new DynatraceTimeSeries(metricId, time, value.doubleValue(), this.extractDimensionValues(tags)));
    }

    private Set<String> extractDimensions(List<Tag> tags) {
        return tags.stream().map(Tag::getKey).collect(Collectors.toSet());
    }

    private Map<String, String> extractDimensionValues(List<Tag> tags) {
        return tags.stream().collect(Collectors.toMap(Tag::getKey, Tag::getValue));
    }

    private boolean isCustomMetricNotCreated(DynatraceMetricDefinition metric) {
        return !this.createdCustomMetrics.contains(metric.getMetricId());
    }

    private boolean isCustomMetricCreated(DynatraceTimeSeries timeSeries) {
        return this.createdCustomMetrics.contains(timeSeries.getMetricId());
    }

    void putCustomMetric(DynatraceMetricDefinition customMetric) {
        try {
            this.httpClient.put(this.customMetricEndpointTemplate + customMetric.getMetricId() + "?api-token=" + this.config.apiToken()).withJsonContent(customMetric.asJson()).send().onSuccess(response -> {
                this.logger.debug("created {} as custom metric in dynatrace", (Object)customMetric.getMetricId());
                this.createdCustomMetrics.add(customMetric.getMetricId());
            }).onError(response -> {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("failed to create custom metric {} in dynatrace: {}", (Object)customMetric.getMetricId(), (Object)response.body());
                }
            });
        }
        catch (Throwable e) {
            this.logger.error("failed to create custom metric in dynatrace: {}", (Object)customMetric.getMetricId(), (Object)e);
        }
    }

    private void postCustomMetricValues(String type, String group, List<DynatraceTimeSeries> timeSeries, String customDeviceMetricEndpoint) {
        try {
            for (DynatraceBatchedPayload postMessage : this.createPostMessages(type, group, timeSeries)) {
                this.httpClient.post(customDeviceMetricEndpoint).withJsonContent(postMessage.payload).send().onSuccess(response -> {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("successfully sent {} metrics to Dynatrace ({} bytes).", (Object)postMessage.metricCount, (Object)postMessage.payload.getBytes(StandardCharsets.UTF_8).length);
                    }
                }).onError(response -> {
                    this.logger.error("failed to send metrics to dynatrace: {}", (Object)response.body());
                    this.logger.debug("failed metrics payload: {}", (Object)postMessage.payload);
                });
            }
        }
        catch (Throwable e) {
            this.logger.error("failed to send metrics to dynatrace", e);
        }
    }

    List<DynatraceBatchedPayload> createPostMessages(String type, String group, List<DynatraceTimeSeries> timeSeries) {
        String header = "{\"type\":\"" + type + '\"' + (StringUtils.isNotBlank((String)group) ? ",\"group\":\"" + group + '\"' : "") + ",\"series\":[";
        String footer = "]}";
        int headerFooterBytes = header.getBytes(StandardCharsets.UTF_8).length + "]}".getBytes(StandardCharsets.UTF_8).length;
        int maxMessageSize = 15360 - headerFooterBytes;
        List<DynatraceBatchedPayload> payloadBodies = this.createPostMessageBodies(timeSeries, maxMessageSize);
        return payloadBodies.stream().map(body -> {
            String message = header + body.payload + "]}";
            return new DynatraceBatchedPayload(message, body.metricCount);
        }).collect(Collectors.toList());
    }

    private List<DynatraceBatchedPayload> createPostMessageBodies(List<DynatraceTimeSeries> timeSeries, long maxSize) {
        ArrayList<DynatraceBatchedPayload> messages = new ArrayList<DynatraceBatchedPayload>();
        StringBuilder payload = new StringBuilder();
        int metricCount = 0;
        long totalByteCount = 0L;
        for (DynatraceTimeSeries ts : timeSeries) {
            String json = ts.asJson();
            int jsonByteCount = json.getBytes(StandardCharsets.UTF_8).length;
            if ((long)jsonByteCount > maxSize) {
                this.logger.debug("Time series data for metric '{}' is too large ({} bytes) to send to Dynatrace.", (Object)ts.getMetricId(), (Object)jsonByteCount);
                continue;
            }
            if (payload.length() == 0 && totalByteCount + (long)jsonByteCount > maxSize || payload.length() > 0 && totalByteCount + (long)jsonByteCount + 1L > maxSize) {
                messages.add(new DynatraceBatchedPayload(payload.toString(), metricCount));
                payload.setLength(0);
                totalByteCount = 0L;
                metricCount = 0;
            }
            if (payload.length() > 0) {
                payload.append(',');
                ++totalByteCount;
            }
            payload.append(json);
            totalByteCount += (long)jsonByteCount;
            ++metricCount;
        }
        if (payload.length() > 0) {
            messages.add(new DynatraceBatchedPayload(payload.toString(), metricCount));
        }
        return messages;
    }

    private Meter.Id idWithSuffix(Meter.Id id, String suffix) {
        return id.withName(id.getName() + "." + suffix);
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    static /* synthetic */ ThreadFactory access$000() {
        return DEFAULT_THREAD_FACTORY;
    }

    public static class Builder {
        private final DynatraceConfig config;
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = DynatraceMeterRegistry.access$000();
        private HttpSender httpClient;

        Builder(DynatraceConfig config) {
            this.config = config;
            this.httpClient = new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout());
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder httpClient(HttpSender httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public DynatraceMeterRegistry build() {
            return new DynatraceMeterRegistry(this.config, this.clock, this.threadFactory, this.httpClient);
        }
    }

    class DynatraceCustomMetric {
        private final DynatraceMetricDefinition metricDefinition;
        private final DynatraceTimeSeries timeSeries;

        DynatraceCustomMetric(DynatraceMetricDefinition metricDefinition, DynatraceTimeSeries timeSeries) {
            this.metricDefinition = metricDefinition;
            this.timeSeries = timeSeries;
        }

        DynatraceMetricDefinition getMetricDefinition() {
            return this.metricDefinition;
        }

        DynatraceTimeSeries getTimeSeries() {
            return this.timeSeries;
        }
    }
}

