/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.dynatrace;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.lang.Nullable;
import java.util.regex.Pattern;

public class DynatraceNamingConvention
implements NamingConvention {
    private static final Pattern NAME_CLEANUP_PATTERN = Pattern.compile("[^\\w._-]");
    private static final Pattern KEY_CLEANUP_PATTERN = Pattern.compile("[^\\w.-]");
    private final NamingConvention delegate;

    public DynatraceNamingConvention(NamingConvention delegate) {
        this.delegate = delegate;
    }

    public DynatraceNamingConvention() {
        this(NamingConvention.dot);
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        return "custom:" + this.sanitizeName(this.delegate.name(name, type, baseUnit));
    }

    private String sanitizeName(String name) {
        if (name.equals("system.load.average.1m")) {
            return "system.load.average.oneminute";
        }
        return NAME_CLEANUP_PATTERN.matcher(name).replaceAll("_");
    }

    public String tagKey(String key) {
        return KEY_CLEANUP_PATTERN.matcher(this.delegate.tagKey(key)).replaceAll("_");
    }
}

