/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.dynatrace;

import io.micrometer.core.instrument.config.MissingRequiredConfigurationException;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.StringUtils;

public interface DynatraceConfig
extends StepRegistryConfig {
    default public String prefix() {
        return "dynatrace";
    }

    default public String apiToken() {
        String v = this.get(this.prefix() + ".apiToken");
        if (v == null) {
            throw new MissingRequiredConfigurationException("apiToken must be set to report metrics to Dynatrace");
        }
        return v;
    }

    default public String uri() {
        String v = this.get(this.prefix() + ".uri");
        if (v == null) {
            throw new MissingRequiredConfigurationException("uri must be set to report metrics to Dynatrace");
        }
        return v;
    }

    default public String deviceId() {
        String v = this.get(this.prefix() + ".deviceId");
        if (v == null) {
            throw new MissingRequiredConfigurationException("deviceId must be set to report metrics to Dynatrace");
        }
        return v;
    }

    default public String technologyType() {
        String v = this.get(this.prefix() + ".technologyType");
        if (StringUtils.isEmpty((String)v)) {
            return "java";
        }
        return v;
    }
}

