/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.datadog;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.core.lang.Nullable;
import io.micrometer.datadog.DatadogConfig;
import io.micrometer.datadog.DatadogMetricMetadata;
import io.micrometer.datadog.DatadogNamingConvention;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatadogMeterRegistry
extends StepMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("datadog-metrics-publisher");
    private final Logger logger = LoggerFactory.getLogger(DatadogMeterRegistry.class);
    private final DatadogConfig config;
    private final HttpSender httpClient;
    private final Set<String> verifiedMetadata = ConcurrentHashMap.newKeySet();

    public DatadogMeterRegistry(DatadogConfig config, Clock clock) {
        this(config, clock, DEFAULT_THREAD_FACTORY, (HttpSender)new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout()));
    }

    @Deprecated
    public DatadogMeterRegistry(DatadogConfig config, Clock clock, ThreadFactory threadFactory) {
        this(config, clock, threadFactory, (HttpSender)new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout()));
    }

    private DatadogMeterRegistry(DatadogConfig config, Clock clock, ThreadFactory threadFactory, HttpSender httpClient) {
        super((StepRegistryConfig)config, clock);
        this.config().namingConvention((NamingConvention)new DatadogNamingConvention());
        this.config = config;
        this.httpClient = httpClient;
        this.start(threadFactory);
    }

    public void start(ThreadFactory threadFactory) {
        if (this.config.enabled() && this.config.applicationKey() == null) {
            this.logger.info("An application key must be configured in order for unit information to be sent to Datadog.");
        }
        super.start(threadFactory);
    }

    protected void publish() {
        HashMap<String, DatadogMetricMetadata> metadataToSend = new HashMap<String, DatadogMetricMetadata>();
        String datadogEndpoint = this.config.uri() + "/api/v1/series?api_key=" + this.config.apiKey();
        try {
            for (List batch : MeterPartition.partition((MeterRegistry)this, (int)this.config.batchSize())) {
                String body = batch.stream().flatMap(meter -> (Stream)meter.match(m -> this.writeMeter((Meter)m, metadataToSend), m -> this.writeMeter((Meter)m, metadataToSend), timer -> this.writeTimer((Timer)timer, (Map<String, DatadogMetricMetadata>)metadataToSend), summary -> this.writeSummary((DistributionSummary)summary, metadataToSend), m -> this.writeMeter((Meter)m, metadataToSend), m -> this.writeMeter((Meter)m, metadataToSend), m -> this.writeMeter((Meter)m, metadataToSend), timer -> this.writeTimer((FunctionTimer)timer, (Map<String, DatadogMetricMetadata>)metadataToSend), m -> this.writeMeter((Meter)m, metadataToSend))).collect(Collectors.joining(",", "{\"series\":[", "]}"));
                this.logger.trace("sending metrics batch to datadog:{}{}", (Object)System.lineSeparator(), (Object)body);
                this.httpClient.post(datadogEndpoint).withJsonContent(body).send().onSuccess(response -> this.logger.debug("successfully sent {} metrics to datadog", (Object)batch.size())).onError(response -> this.logger.error("failed to send metrics to datadog: {}", (Object)response.body()));
            }
        }
        catch (Throwable e) {
            this.logger.warn("failed to send metrics to datadog", e);
        }
        metadataToSend.forEach(this::postMetricMetadata);
    }

    private Stream<String> writeTimer(FunctionTimer timer, Map<String, DatadogMetricMetadata> metadata) {
        long wallTime = this.clock.wallTime();
        Meter.Id id = timer.getId();
        this.addToMetadataList(metadata, id, "count", Statistic.COUNT, "occurrence");
        this.addToMetadataList(metadata, id, "avg", Statistic.VALUE, null);
        this.addToMetadataList(metadata, id, "sum", Statistic.TOTAL_TIME, null);
        return Stream.of(this.writeMetric(id, "count", wallTime, timer.count(), Statistic.COUNT, "occurrence"), this.writeMetric(id, "avg", wallTime, timer.mean(this.getBaseTimeUnit()), Statistic.VALUE, null), this.writeMetric(id, "sum", wallTime, timer.totalTime(this.getBaseTimeUnit()), Statistic.TOTAL_TIME, null));
    }

    private Stream<String> writeTimer(Timer timer, Map<String, DatadogMetricMetadata> metadata) {
        long wallTime = this.clock.wallTime();
        Stream.Builder<String> metrics = Stream.builder();
        Meter.Id id = timer.getId();
        metrics.add(this.writeMetric(id, "sum", wallTime, timer.totalTime(this.getBaseTimeUnit()), Statistic.TOTAL_TIME, null));
        metrics.add(this.writeMetric(id, "count", wallTime, timer.count(), Statistic.COUNT, "occurrence"));
        metrics.add(this.writeMetric(id, "avg", wallTime, timer.mean(this.getBaseTimeUnit()), Statistic.VALUE, null));
        metrics.add(this.writeMetric(id, "max", wallTime, timer.max(this.getBaseTimeUnit()), Statistic.MAX, null));
        this.addToMetadataList(metadata, id, "sum", Statistic.TOTAL_TIME, null);
        this.addToMetadataList(metadata, id, "count", Statistic.COUNT, "occurrence");
        this.addToMetadataList(metadata, id, "avg", Statistic.VALUE, null);
        this.addToMetadataList(metadata, id, "max", Statistic.MAX, null);
        return metrics.build();
    }

    private Stream<String> writeSummary(DistributionSummary summary, Map<String, DatadogMetricMetadata> metadata) {
        long wallTime = this.clock.wallTime();
        Stream.Builder<String> metrics = Stream.builder();
        Meter.Id id = summary.getId();
        metrics.add(this.writeMetric(id, "sum", wallTime, summary.totalAmount(), Statistic.TOTAL, null));
        metrics.add(this.writeMetric(id, "count", wallTime, summary.count(), Statistic.COUNT, "occurrence"));
        metrics.add(this.writeMetric(id, "avg", wallTime, summary.mean(), Statistic.VALUE, null));
        metrics.add(this.writeMetric(id, "max", wallTime, summary.max(), Statistic.MAX, null));
        this.addToMetadataList(metadata, id, "sum", Statistic.TOTAL_TIME, null);
        this.addToMetadataList(metadata, id, "count", Statistic.COUNT, "occurrence");
        this.addToMetadataList(metadata, id, "avg", Statistic.VALUE, null);
        this.addToMetadataList(metadata, id, "max", Statistic.MAX, null);
        return metrics.build();
    }

    private Stream<String> writeMeter(Meter m, Map<String, DatadogMetricMetadata> metadata) {
        long wallTime = this.clock.wallTime();
        return StreamSupport.stream(m.measure().spliterator(), false).map(ms -> {
            Meter.Id id = m.getId().withTag(ms.getStatistic());
            this.addToMetadataList(metadata, id, null, ms.getStatistic(), null);
            return this.writeMetric(id, null, wallTime, ms.getValue(), ms.getStatistic(), null);
        });
    }

    private void addToMetadataList(Map<String, DatadogMetricMetadata> metadata, Meter.Id id, @Nullable String suffix, Statistic stat, @Nullable String overrideBaseUnit) {
        String metricName;
        if (this.config.applicationKey() == null) {
            return;
        }
        Meter.Id fullId = id;
        if (suffix != null) {
            fullId = this.idWithSuffix(id, suffix);
        }
        if (!this.verifiedMetadata.contains(metricName = this.getConventionName(fullId))) {
            metadata.put(metricName, new DatadogMetricMetadata(fullId, stat, this.config.descriptions(), overrideBaseUnit));
        }
    }

    String writeMetric(Meter.Id id, @Nullable String suffix, long wallTime, double value, Statistic statistic, @Nullable String overrideBaseUnit) {
        Meter.Id fullId = id;
        if (suffix != null) {
            fullId = this.idWithSuffix(id, suffix);
        }
        List tags = this.getConventionTags(fullId);
        String host = this.config.hostTag() == null ? "" : StreamSupport.stream(tags.spliterator(), false).filter(t -> this.config.hostTag().equals(t.getKey())).findAny().map(t -> ",\"host\":\"" + StringEscapeUtils.escapeJson((String)t.getValue()) + "\"").orElse("");
        String type = ",\"type\":\"" + DatadogMetricMetadata.sanitizeType(statistic) + "\"";
        String baseUnit = DatadogMetricMetadata.sanitizeBaseUnit(id.getBaseUnit(), overrideBaseUnit);
        String unit = baseUnit != null ? ",\"unit\":\"" + baseUnit + "\"" : "";
        String tagsArray = tags.iterator().hasNext() ? StreamSupport.stream(tags.spliterator(), false).map(t -> "\"" + StringEscapeUtils.escapeJson((String)t.getKey()) + ":" + StringEscapeUtils.escapeJson((String)t.getValue()) + "\"").collect(Collectors.joining(",", ",\"tags\":[", "]")) : "";
        return "{\"metric\":\"" + StringEscapeUtils.escapeJson((String)this.getConventionName(fullId)) + "\",\"points\":[[" + wallTime / 1000L + ", " + value + "]]" + host + type + unit + tagsArray + "}";
    }

    void postMetricMetadata(String metricName, DatadogMetricMetadata metadata) {
        if (metadata.editMetadataBody() == null || this.verifiedMetadata.contains(metricName)) {
            return;
        }
        try {
            this.httpClient.put(this.config.uri() + "/api/v1/metrics/" + URLEncoder.encode(metricName, "UTF-8") + "?api_key=" + this.config.apiKey() + "&application_key=" + this.config.applicationKey()).withJsonContent(metadata.editMetadataBody()).send().onSuccess(response -> this.verifiedMetadata.add(metricName)).onError(response -> {
                String msg;
                if (this.logger.isErrorEnabled() && !(msg = response.body()).contains("metric_name not found")) {
                    this.logger.error("failed to send metric metadata to datadog: {}", (Object)msg);
                }
            });
        }
        catch (Throwable e) {
            this.logger.warn("failed to send metric metadata to datadog", e);
        }
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    private Meter.Id idWithSuffix(Meter.Id id, String suffix) {
        return id.withName(id.getName() + "." + suffix);
    }

    public static Builder builder(DatadogConfig config) {
        return new Builder(config);
    }

    static /* synthetic */ ThreadFactory access$000() {
        return DEFAULT_THREAD_FACTORY;
    }

    public static class Builder {
        private final DatadogConfig config;
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = DatadogMeterRegistry.access$000();
        private HttpSender httpClient;

        Builder(DatadogConfig config) {
            this.config = config;
            this.httpClient = new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout());
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder httpClient(HttpSender httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public DatadogMeterRegistry build() {
            return new DatadogMeterRegistry(this.config, this.clock, this.threadFactory, this.httpClient);
        }
    }
}

