/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.datadog;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import io.micrometer.core.lang.Nullable;

public class DatadogNamingConvention
implements NamingConvention {
    private final NamingConvention delegate;

    public DatadogNamingConvention() {
        this(NamingConvention.dot);
    }

    public DatadogNamingConvention(NamingConvention delegate) {
        this.delegate = delegate;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        String sanitized = StringEscapeUtils.escapeJson((String)this.delegate.name(name, type, baseUnit));
        if (!Character.isLetter(sanitized.charAt(0))) {
            sanitized = "m." + sanitized;
        }
        if (sanitized.length() > 200) {
            return sanitized.substring(0, 200);
        }
        return sanitized;
    }

    public String tagKey(String key) {
        String sanitized = StringEscapeUtils.escapeJson((String)this.delegate.tagKey(key));
        if (Character.isDigit(sanitized.charAt(0))) {
            sanitized = "m." + sanitized;
        }
        return sanitized;
    }

    public String tagValue(String value) {
        return StringEscapeUtils.escapeJson((String)this.delegate.tagValue(value));
    }
}

