/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.datadog;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.HistogramSnapshot;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.ValueAtPercentile;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.datadog.DatadogConfig;
import io.micrometer.datadog.DatadogNamingConvention;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatadogMeterRegistry
extends StepMeterRegistry {
    private final URL metricsEndpoint;
    private final Logger logger = LoggerFactory.getLogger(DatadogMeterRegistry.class);
    private final DatadogConfig config;
    private final DecimalFormat percentileFormat = new DecimalFormat("#.####");
    private final Map<Meter, HistogramConfig> histogramConfigs = new ConcurrentHashMap<Meter, HistogramConfig>();

    public DatadogMeterRegistry(DatadogConfig config, Clock clock) {
        super((StepRegistryConfig)config, clock);
        this.config().namingConvention((NamingConvention)new DatadogNamingConvention());
        try {
            this.metricsEndpoint = URI.create(config.uri()).toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.config = config;
        this.start();
    }

    public DatadogMeterRegistry(DatadogConfig config) {
        this(config, Clock.SYSTEM);
    }

    protected void publish() {
        try {
            for (List batch : MeterPartition.partition((MeterRegistry)this, (int)this.config.batchSize())) {
                HttpURLConnection con = (HttpURLConnection)this.metricsEndpoint.openConnection();
                con.setConnectTimeout((int)this.config.connectTimeout().toMillis());
                con.setReadTimeout((int)this.config.readTimeout().toMillis());
                con.setRequestMethod("POST");
                con.setRequestProperty("Content-Type", "application/json");
                con.setDoOutput(true);
                String body = "{\"series\":[" + batch.stream().flatMap(m -> {
                    if (m instanceof Timer) {
                        return this.writeTimer((Timer)m);
                    }
                    if (m instanceof DistributionSummary) {
                        return this.writeSummary((DistributionSummary)m);
                    }
                    if (m instanceof FunctionTimer) {
                        return this.writeTimer((FunctionTimer)m);
                    }
                    return this.writeMeter((Meter)m);
                }).collect(Collectors.joining(",")) + "]}";
                try (OutputStream os = con.getOutputStream();){
                    os.write(body.getBytes());
                    os.flush();
                }
                int status = con.getResponseCode();
                if (status >= 200 && status < 300) {
                    this.logger.info("successfully sent " + batch.size() + " metrics to datadog");
                } else if (status >= 400) {
                    try (InputStream in = con.getErrorStream();){
                        this.logger.error("failed to send metrics: " + new BufferedReader(new InputStreamReader(in)).lines().collect(Collectors.joining("\n")));
                    }
                } else {
                    this.logger.error("failed to send metrics: http " + status);
                }
                con.disconnect();
            }
        }
        catch (Exception e) {
            this.logger.warn("failed to send metrics", (Throwable)e);
        }
    }

    private Stream<String> writeTimer(FunctionTimer timer) {
        long wallTime = this.clock.wallTime();
        return Stream.of(this.writeMetric(this.idWithSuffix(timer.getId(), "count"), wallTime, timer.count()), this.writeMetric(this.idWithSuffix(timer.getId(), "avg"), wallTime, timer.mean(this.getBaseTimeUnit())));
    }

    private Stream<String> writeTimer(Timer timer) {
        long wallTime = this.clock.wallTime();
        HistogramSnapshot snapshot = timer.takeSnapshot(false);
        Stream.Builder<String> metrics = Stream.builder();
        metrics.add(this.writeMetric(this.idWithSuffix(timer.getId(), "sum"), wallTime, snapshot.total(this.getBaseTimeUnit())));
        metrics.add(this.writeMetric(this.idWithSuffix(timer.getId(), "count"), wallTime, snapshot.count()));
        metrics.add(this.writeMetric(this.idWithSuffix(timer.getId(), "avg"), wallTime, snapshot.mean(this.getBaseTimeUnit())));
        metrics.add(this.writeMetric(this.idWithSuffix(timer.getId(), "max"), wallTime, snapshot.max(this.getBaseTimeUnit())));
        for (ValueAtPercentile v : snapshot.percentileValues()) {
            metrics.add(this.writeMetric(this.idWithSuffix(timer.getId(), this.percentileFormat.format(v.percentile()) + "percentile"), wallTime, v.value(this.getBaseTimeUnit())));
        }
        return metrics.build();
    }

    private Stream<String> writeSummary(DistributionSummary summary) {
        long wallTime = this.clock.wallTime();
        HistogramSnapshot snapshot = summary.takeSnapshot(false);
        Stream.Builder<String> metrics = Stream.builder();
        metrics.add(this.writeMetric(this.idWithSuffix(summary.getId(), "sum"), wallTime, snapshot.total()));
        metrics.add(this.writeMetric(this.idWithSuffix(summary.getId(), "count"), wallTime, snapshot.count()));
        metrics.add(this.writeMetric(this.idWithSuffix(summary.getId(), "avg"), wallTime, snapshot.mean()));
        metrics.add(this.writeMetric(this.idWithSuffix(summary.getId(), "max"), wallTime, snapshot.max()));
        for (ValueAtPercentile v : snapshot.percentileValues()) {
            metrics.add(this.writeMetric(this.idWithSuffix(summary.getId(), this.percentileFormat.format(v.percentile()) + "percentile"), wallTime, v.value()));
        }
        return metrics.build();
    }

    private Stream<String> writeMeter(Meter m) {
        long wallTime = this.clock.wallTime();
        return StreamSupport.stream(m.measure().spliterator(), false).map(ms -> this.writeMetric(m.getId().withTag(ms.getStatistic()), wallTime, ms.getValue()));
    }

    private String writeMetric(Meter.Id id, long wallTime, double value) {
        Iterable tags = id.getTags();
        String host = this.config.hostTag() == null ? "" : StreamSupport.stream(tags.spliterator(), false).filter(t -> this.config.hostTag().equals(t.getKey())).findAny().map(t -> ",\"host\":" + t.getValue()).orElse("");
        String tagsArray = tags.iterator().hasNext() ? ",\"tags\":[" + StreamSupport.stream(tags.spliterator(), false).map(t -> "\"" + t.getKey() + ":" + t.getValue() + "\"").collect(Collectors.joining(",")) + "]" : "";
        return "{\"metric\":\"" + id.getConventionName(this.config().namingConvention()) + "\",\"points\":[[" + wallTime / 1000L + ", " + value + "]]" + host + tagsArray + "}";
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    private Meter.Id idWithSuffix(Meter.Id id, String suffix) {
        return new Meter.Id(id.getName() + "." + suffix, id.getTags(), id.getBaseUnit(), id.getDescription(), id.getType());
    }
}

