/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.datadog;

import com.netflix.spectator.api.Clock;
import io.micrometer.core.instrument.spectator.step.AbstractStepRegistry;
import io.micrometer.core.instrument.spectator.step.StepRegistryConfig;
import io.micrometer.datadog.DatadogConfig;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

final class DatadogRegistry
extends AbstractStepRegistry {
    private final URL metricsEndpoint;
    private final String hostTag;

    public DatadogRegistry(DatadogConfig config, Clock clock) {
        super((StepRegistryConfig)config, clock);
        try {
            this.metricsEndpoint = URI.create("https://app.datadoghq.com/api/v1/series?api_key=" + config.apiKey()).toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.hostTag = config.hostTag();
    }

    protected void pushMetrics() {
        try {
            for (List batch : this.getBatches()) {
                HttpURLConnection con = (HttpURLConnection)this.metricsEndpoint.openConnection();
                con.setConnectTimeout(this.connectTimeout);
                con.setReadTimeout(this.readTimeout);
                con.setRequestMethod("POST");
                con.setRequestProperty("Content-Type", "application/json");
                con.setDoOutput(true);
                String body = "{\"series\":[" + batch.stream().map(m -> {
                    Iterable tags = m.id().tags();
                    String host = this.hostTag == null ? "" : StreamSupport.stream(tags.spliterator(), false).filter(t -> this.hostTag.equals(t.key())).findAny().map(t -> ",\"host\":" + t.value()).orElse("");
                    String tagsArray = tags.iterator().hasNext() ? ",\"tags\":[" + StreamSupport.stream(tags.spliterator(), false).map(t -> "\"" + t.key() + ":" + t.value() + "\"").collect(Collectors.joining(",")) + "]" : "";
                    return "{\"metric\":\"" + m.id().name() + "\",\"points\":[[" + m.timestamp() / 1000L + ", " + m.value() + "]]" + host + tagsArray + "}";
                }).collect(Collectors.joining(",")) + "]}";
                try (OutputStream os = con.getOutputStream();){
                    os.write(body.getBytes());
                    os.flush();
                }
                int status = con.getResponseCode();
                if (status >= 200 && status < 300) {
                    this.logger.info("successfully sent " + batch.size() + " metrics to datadog");
                } else if (status >= 400) {
                    try (InputStream in = status >= 400 ? con.getErrorStream() : con.getInputStream();){
                        this.logger.error("failed to send metrics: " + new BufferedReader(new InputStreamReader(in)).lines().collect(Collectors.joining("\n")));
                    }
                } else {
                    this.logger.error("failed to send metrics: http " + status);
                }
                con.disconnect();
            }
        }
        catch (Exception e) {
            this.logger.warn("failed to send metrics", (Throwable)e);
        }
    }
}

