/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.cloudwatch;

import com.amazonaws.services.cloudwatch.model.MetricDatum;
import io.micrometer.core.instrument.util.MathUtils;
import java.util.AbstractList;
import java.util.List;

public class MetricDatumPartition
extends AbstractList<List<MetricDatum>> {
    private final List<MetricDatum> list;
    private final int partitionSize;
    private final int partitionCount;

    public MetricDatumPartition(List<MetricDatum> metricData, int partitionSize) {
        this.list = metricData;
        this.partitionSize = partitionSize;
        this.partitionCount = MathUtils.divideWithCeilingRoundingMode((int)this.list.size(), (int)partitionSize);
    }

    public static List<List<MetricDatum>> partition(List<MetricDatum> metricData, int partitionSize) {
        return new MetricDatumPartition(metricData, partitionSize);
    }

    @Override
    public List<MetricDatum> get(int index) {
        int start = index * this.partitionSize;
        int end = Math.min(start + this.partitionSize, this.list.size());
        return this.list.subList(start, end);
    }

    @Override
    public int size() {
        return this.partitionCount;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }
}

