/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.cloudwatch;

import io.micrometer.core.instrument.config.InvalidConfigurationException;
import io.micrometer.core.instrument.config.MissingRequiredConfigurationException;
import io.micrometer.core.instrument.step.StepRegistryConfig;

public interface CloudWatchConfig
extends StepRegistryConfig {
    public static final int MAX_BATCH_SIZE = 20;
    public static final CloudWatchConfig DEFAULT = k -> null;

    default public String prefix() {
        return "cloudwatch";
    }

    default public String namespace() {
        String v = this.get(this.prefix() + ".namespace");
        if (v == null) {
            throw new MissingRequiredConfigurationException("namespace must be set to report metrics to CloudWatch");
        }
        return v;
    }

    default public int batchSize() {
        String v = this.get(this.prefix() + ".batchSize");
        if (v == null) {
            return 20;
        }
        int vInt = Integer.parseInt(v);
        if (vInt > 20) {
            throw new InvalidConfigurationException("batchSize must be <= 20");
        }
        return vInt;
    }
}

