/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.cloudwatch;

import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsync;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.PutMetricDataResult;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import io.micrometer.cloudwatch.CloudWatchConfig;
import io.micrometer.cloudwatch.CloudWatchUtils;
import io.micrometer.cloudwatch.MetricDatumPartition;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.core.lang.Nullable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudWatchMeterRegistry
extends StepMeterRegistry {
    private final CloudWatchConfig config;
    private final AmazonCloudWatchAsync amazonCloudWatchAsync;
    private final Logger logger = LoggerFactory.getLogger(CloudWatchMeterRegistry.class);

    public CloudWatchMeterRegistry(CloudWatchConfig config, Clock clock, AmazonCloudWatchAsync amazonCloudWatchAsync) {
        this(config, clock, amazonCloudWatchAsync, Executors.defaultThreadFactory());
    }

    public CloudWatchMeterRegistry(CloudWatchConfig config, Clock clock, AmazonCloudWatchAsync amazonCloudWatchAsync, ThreadFactory threadFactory) {
        super((StepRegistryConfig)config, clock);
        Objects.requireNonNull(config.namespace());
        this.amazonCloudWatchAsync = amazonCloudWatchAsync;
        this.config = config;
        this.config().namingConvention(NamingConvention.identity);
        this.start(threadFactory);
    }

    protected void publish() {
        for (List<MetricDatum> batch : MetricDatumPartition.partition(this.metricData(), this.config.batchSize())) {
            this.sendMetricData(batch);
        }
    }

    private void sendMetricData(List<MetricDatum> metricData) {
        PutMetricDataRequest putMetricDataRequest = new PutMetricDataRequest().withNamespace(this.config.namespace()).withMetricData(metricData);
        this.amazonCloudWatchAsync.putMetricDataAsync(putMetricDataRequest, (AsyncHandler)new AsyncHandler<PutMetricDataRequest, PutMetricDataResult>(){

            public void onError(Exception exception) {
                CloudWatchMeterRegistry.this.logger.error("Error sending metric data.", (Throwable)exception);
            }

            public void onSuccess(PutMetricDataRequest request, PutMetricDataResult result) {
                CloudWatchMeterRegistry.this.logger.debug("Published metric with namespace:{}", (Object)request.getNamespace());
            }
        });
    }

    private List<MetricDatum> metricData() {
        return this.getMeters().stream().flatMap(m -> {
            if (m instanceof Timer) {
                return this.metricData((Timer)m);
            }
            if (m instanceof DistributionSummary) {
                return this.metricData((DistributionSummary)m);
            }
            if (m instanceof FunctionTimer) {
                return this.metricData((FunctionTimer)m);
            }
            return this.metricData((Meter)m);
        }).collect(Collectors.toList());
    }

    private Stream<MetricDatum> metricData(FunctionTimer timer) {
        long wallTime = this.clock.wallTime();
        return Stream.of(this.metricDatum(this.idWithSuffix(timer.getId(), "count"), wallTime, timer.count()), this.metricDatum(this.idWithSuffix(timer.getId(), "avg"), wallTime, timer.mean(this.getBaseTimeUnit())));
    }

    private Stream<MetricDatum> metricData(Timer timer) {
        long wallTime = this.clock.wallTime();
        HistogramSnapshot snapshot = timer.takeSnapshot(false);
        Stream.Builder<MetricDatum> metrics = Stream.builder();
        metrics.add(this.metricDatum(this.idWithSuffixAndUnit(timer.getId(), "sum", this.getBaseTimeUnit().name()), wallTime, snapshot.total(this.getBaseTimeUnit())));
        metrics.add(this.metricDatum(this.idWithSuffixAndUnit(timer.getId(), "count", "count"), wallTime, snapshot.count()));
        metrics.add(this.metricDatum(this.idWithSuffixAndUnit(timer.getId(), "avg", this.getBaseTimeUnit().name()), wallTime, snapshot.mean(this.getBaseTimeUnit())));
        metrics.add(this.metricDatum(this.idWithSuffixAndUnit(timer.getId(), "max", this.getBaseTimeUnit().name()), wallTime, snapshot.max(this.getBaseTimeUnit())));
        for (ValueAtPercentile v : snapshot.percentileValues()) {
            metrics.add(this.metricDatum(this.idWithSuffix(timer.getId(), DoubleFormat.decimalOrNan((double)v.percentile()) + "percentile"), wallTime, v.value(this.getBaseTimeUnit())));
        }
        return metrics.build();
    }

    private Stream<MetricDatum> metricData(DistributionSummary summary) {
        long wallTime = this.clock.wallTime();
        HistogramSnapshot snapshot = summary.takeSnapshot(false);
        Stream.Builder<MetricDatum> metrics = Stream.builder();
        metrics.add(this.metricDatum(this.idWithSuffix(summary.getId(), "sum"), wallTime, snapshot.total()));
        metrics.add(this.metricDatum(this.idWithSuffix(summary.getId(), "count"), wallTime, snapshot.count()));
        metrics.add(this.metricDatum(this.idWithSuffix(summary.getId(), "avg"), wallTime, snapshot.mean()));
        metrics.add(this.metricDatum(this.idWithSuffix(summary.getId(), "max"), wallTime, snapshot.max()));
        for (ValueAtPercentile v : snapshot.percentileValues()) {
            metrics.add(this.metricDatum(this.idWithSuffix(summary.getId(), DoubleFormat.decimalOrNan((double)v.percentile()) + "percentile"), wallTime, v.value()));
        }
        return metrics.build();
    }

    private Stream<MetricDatum> metricData(Meter m) {
        long wallTime = this.clock.wallTime();
        return StreamSupport.stream(m.measure().spliterator(), false).map(ms -> this.metricDatum(m.getId().withTag(ms.getStatistic()), wallTime, ms.getValue()));
    }

    private MetricDatum metricDatum(Meter.Id id, long wallTime, double value) {
        String metricName = id.getConventionName(this.config().namingConvention());
        List tags = id.getConventionTags(this.config().namingConvention());
        return new MetricDatum().withMetricName(metricName).withDimensions(this.toDimensions(tags)).withTimestamp(new Date(wallTime)).withValue(Double.valueOf(CloudWatchUtils.clampMetricValue(value))).withUnit(this.toStandardUnit(id.getBaseUnit()));
    }

    private StandardUnit toStandardUnit(@Nullable String unit) {
        if (unit == null) {
            return StandardUnit.None;
        }
        switch (unit.toLowerCase()) {
            case "bytes": {
                return StandardUnit.Bytes;
            }
            case "milliseconds": {
                return StandardUnit.Milliseconds;
            }
            case "count": {
                return StandardUnit.Count;
            }
        }
        return StandardUnit.None;
    }

    private List<Dimension> toDimensions(List<Tag> tags) {
        return tags.stream().map(tag -> new Dimension().withName(tag.getKey()).withValue(tag.getValue())).collect(Collectors.toList());
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    private Meter.Id idWithSuffix(Meter.Id id, String suffix) {
        return this.idWithSuffixAndUnit(id, suffix, id.getBaseUnit());
    }

    private Meter.Id idWithSuffixAndUnit(Meter.Id id, String suffix, @Nullable String unit) {
        return new Meter.Id(id.getName() + "." + suffix, (Iterable)id.getTags(), unit, id.getDescription(), id.getType());
    }
}

