/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.azuremonitor;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.lang.Nullable;
import java.util.regex.Pattern;

public class AzureMonitorNamingConvention
implements NamingConvention {
    private static final Pattern NAME_AND_TAG_KEY_PATTERN = Pattern.compile("[^a-zA-Z0-9\\-]");
    private final NamingConvention delegate;

    public AzureMonitorNamingConvention() {
        this(NamingConvention.snakeCase);
    }

    public AzureMonitorNamingConvention(NamingConvention delegate) {
        this.delegate = delegate;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        return NAME_AND_TAG_KEY_PATTERN.matcher(this.delegate.name(name, type, baseUnit)).replaceAll("_");
    }

    public String tagKey(String key) {
        return NAME_AND_TAG_KEY_PATTERN.matcher(this.delegate.tagKey(key)).replaceAll("_");
    }
}

